/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.data;

import cn.dinodev.spring.commons.data.ValueLabel;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public class Option<V extends Serializable>
implements ValueLabel<V> {
    @Schema(description="\u9009\u9879\u503c", required=true)
    private V value;
    @Schema(description="\u9009\u9879\u6807\u7b7e", required=true)
    private String label;
    @Schema(description="\u9009\u9879\u7684\u56fe\u6807")
    @Nullable
    private String icon;
    @Schema(description="\u9009\u9879\u7684\u6837\u5f0f")
    @Nullable
    private String style;
    @Schema(description="\u9009\u9879\u7684\u63cf\u8ff0")
    @Nullable
    private String desc;

    public static <V extends Serializable> Option<V> fromValueLabel(ValueLabel<V> vl) {
        Option<V> option = new Option<V>();
        option.setValue(vl.getValue());
        option.setLabel(vl.getLabel());
        return option;
    }

    public static <V extends Serializable> Option<V> fromValueLabel(ValueLabel<V> vl, Supplier<String> iconSupplier) {
        Option<V> option = Option.fromValueLabel(vl);
        option.setIcon(iconSupplier.get());
        return option;
    }

    public static <V extends Serializable> Option<V> fromValueLabel(ValueLabel<V> vl, Supplier<String> iconSupplier, Supplier<String> styleSupplier) {
        Option<V> option = Option.fromValueLabel(vl, iconSupplier);
        option.setStyle(styleSupplier.get());
        return option;
    }

    public static <V extends Serializable> Option<V> fromValueLabel(ValueLabel<V> vl, Supplier<String> iconSupplier, Supplier<String> styleSupplier, Supplier<String> descSupplier) {
        Option<V> option = Option.fromValueLabel(vl, iconSupplier, styleSupplier);
        option.setDesc(descSupplier.get());
        return option;
    }

    public static <V extends Serializable> Option<V> fromValueLabel(ValueLabel<V> vl, Function<V, String> iconMapper) {
        Option<V> option = Option.fromValueLabel(vl);
        option.setIcon(iconMapper.apply(vl.getValue()));
        return option;
    }

    public static <V extends Serializable> Option<V> fromValueLabel(ValueLabel<V> vl, Function<V, String> iconMapper, Function<V, String> styleMapper) {
        Option<V> option = Option.fromValueLabel(vl, iconMapper);
        option.setStyle(styleMapper.apply(vl.getValue()));
        return option;
    }

    public static <V extends Serializable> Option<V> fromValueLabel(ValueLabel<V> vl, Function<V, String> iconMapper, Function<V, String> styleMapper, Function<V, String> descMapper) {
        Option<V> option = Option.fromValueLabel(vl, iconMapper, styleMapper);
        option.setDesc(descMapper.apply(vl.getValue()));
        return option;
    }

    @Generated
    public Option() {
    }

    @Override
    @Generated
    public V getValue() {
        return this.value;
    }

    @Override
    @Generated
    public String getLabel() {
        return this.label;
    }

    @Nullable
    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Nullable
    @Generated
    public String getStyle() {
        return this.style;
    }

    @Nullable
    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public void setValue(V value) {
        this.value = value;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setIcon(@Nullable String icon) {
        this.icon = icon;
    }

    @Generated
    public void setStyle(@Nullable String style) {
        this.style = style;
    }

    @Generated
    public void setDesc(@Nullable String desc) {
        this.desc = desc;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option other = (Option)o;
        if (!other.canEqual(this)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Option;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Option(value=" + String.valueOf(this.getValue()) + ", label=" + this.getLabel() + ", icon=" + this.getIcon() + ", style=" + this.getStyle() + ", desc=" + this.getDesc() + ")";
    }
}

