/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.crypto;

import cn.dinodev.spring.commons.crypto.Sm2;
import java.math.BigInteger;
import lombok.Generated;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;

public class Sm2Signature {
    private BigInteger signatureR;
    private BigInteger signatureS;

    public String toString() {
        return this.signatureR.toString(16) + "," + this.signatureS.toString(16);
    }

    public static Sm2Signature fromStandardDSA(byte[] signDSAEncoding) {
        return Sm2Signature.fromStandardDSA((DSAEncoding)StandardDSAEncoding.INSTANCE, signDSAEncoding);
    }

    public static Sm2Signature fromStandardDSA(DSAEncoding dsaEncoding, byte[] signDSAEncoding) {
        BigInteger[] decodedValues = dsaEncoding.decode(Sm2.SM2_ECC_N, signDSAEncoding);
        BigInteger signatureRValue = decodedValues[0];
        BigInteger signatureSValue = decodedValues[1];
        return new Sm2Signature(signatureRValue, signatureSValue);
    }

    @Generated
    public BigInteger getSignatureR() {
        return this.signatureR;
    }

    @Generated
    public BigInteger getSignatureS() {
        return this.signatureS;
    }

    @Generated
    public void setSignatureR(BigInteger signatureR) {
        this.signatureR = signatureR;
    }

    @Generated
    public void setSignatureS(BigInteger signatureS) {
        this.signatureS = signatureS;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sm2Signature)) {
            return false;
        }
        Sm2Signature other = (Sm2Signature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$signatureR = this.getSignatureR();
        BigInteger other$signatureR = other.getSignatureR();
        if (this$signatureR == null ? other$signatureR != null : !((Object)this$signatureR).equals(other$signatureR)) {
            return false;
        }
        BigInteger this$signatureS = this.getSignatureS();
        BigInteger other$signatureS = other.getSignatureS();
        return !(this$signatureS == null ? other$signatureS != null : !((Object)this$signatureS).equals(other$signatureS));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Sm2Signature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $signatureR = this.getSignatureR();
        result = result * 59 + ($signatureR == null ? 43 : ((Object)$signatureR).hashCode());
        BigInteger $signatureS = this.getSignatureS();
        result = result * 59 + ($signatureS == null ? 43 : ((Object)$signatureS).hashCode());
        return result;
    }

    @Generated
    public Sm2Signature() {
    }

    @Generated
    public Sm2Signature(BigInteger signatureR, BigInteger signatureS) {
        this.signatureR = signatureR;
        this.signatureS = signatureS;
    }
}

