/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.crypto;

import cn.dinodev.spring.commons.crypto.KeyPair;
import cn.dinodev.spring.commons.crypto.Sm2Signature;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import lombok.Generated;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;

public final class Sm2 {
    public static final SM2P256V1Curve CURVE;
    public static final BigInteger SM2_ECC_P;
    public static final BigInteger SM2_ECC_A;
    public static final BigInteger SM2_ECC_B;
    public static final BigInteger SM2_ECC_N;
    public static final BigInteger SM2_ECC_H;
    public static final BigInteger SM2_ECC_GX;
    public static final BigInteger SM2_ECC_GY;
    public static final org.bouncycastle.math.ec.ECPoint G_POINT;
    public static final ECDomainParameters SM2_DOMAIN;
    public static final int CURVE_LEN;
    public static final EllipticCurve JDK_CURVE;
    public static final ECPoint JDK_G_POINT;
    public static final ECParameterSpec JDK_EC_SPEC;

    public static int getCurveLength(ECDomainParameters domainParams) {
        return (domainParams.getCurve().getFieldSize() + 7) / 8;
    }

    public static KeyPair generateKeyPair() {
        SecureRandom random = new SecureRandom();
        ECKeyGenerationParameters keyGenerationParams = new ECKeyGenerationParameters(SM2_DOMAIN, random);
        ECKeyPairGenerator keyGen = new ECKeyPairGenerator();
        keyGen.init((KeyGenerationParameters)keyGenerationParams);
        AsymmetricCipherKeyPair keyPair = keyGen.generateKeyPair();
        ECPublicKeyParameters ecPublicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
        ECPrivateKeyParameters ecPrivateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
        return new KeyPair(Sm2.getRawPrivateKey(ecPrivateKeyParameters), Sm2.getRawPublicKey(ecPublicKeyParameters));
    }

    public static ECPublicKeyParameters buildECPublicKeyParameters(byte[] publicKey) {
        org.bouncycastle.math.ec.ECPoint pointQ = CURVE.createPoint(new BigInteger(1, publicKey, 0, 32), new BigInteger(1, publicKey, 32, 32));
        return new ECPublicKeyParameters(pointQ, SM2_DOMAIN);
    }

    public static ECPrivateKeyParameters buildECPrivateKeyParameters(byte[] privateKey) {
        BigInteger privateKeyValue = new BigInteger(1, privateKey);
        return new ECPrivateKeyParameters(privateKeyValue, SM2_DOMAIN);
    }

    public static byte[] getRawPrivateKey(ECPrivateKeyParameters privateKey) {
        return Sm2.toCurveLengthBytes(privateKey.getD().toByteArray());
    }

    public static byte[] getRawPublicKey(ECPublicKeyParameters publicKey) {
        byte[] src65 = publicKey.getQ().getEncoded(false);
        byte[] rawXY = new byte[CURVE_LEN * 2];
        System.arraycopy(src65, 1, rawXY, 0, rawXY.length);
        return rawXY;
    }

    public static byte[] encrypt(byte[] input, ECPublicKeyParameters ecPublicKeyParameters, SM2Engine.Mode mode) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine(mode);
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom());
        engine.init(true, (CipherParameters)parametersWithRandom);
        return engine.processBlock(input, 0, input.length);
    }

    public static byte[] encrypt(byte[] input, byte[] publicKey, SM2Engine.Mode mode) throws InvalidCipherTextException {
        ECPublicKeyParameters ecPublicKeyParameters = Sm2.buildECPublicKeyParameters(publicKey);
        return Sm2.encrypt(input, ecPublicKeyParameters, mode);
    }

    public static byte[] encrypt(byte[] input, byte[] publicKey) throws InvalidCipherTextException {
        ECPublicKeyParameters ecPublicKeyParameters = Sm2.buildECPublicKeyParameters(publicKey);
        return Sm2.encrypt(input, ecPublicKeyParameters, SM2Engine.Mode.C1C2C3);
    }

    public static byte[] decrypt(byte[] input, ECPrivateKeyParameters ecPrivateKeyParameters, SM2Engine.Mode mode) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine(mode);
        engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        return engine.processBlock(input, 0, input.length);
    }

    public static byte[] decrypt(byte[] input, byte[] privateKey, SM2Engine.Mode mode) throws InvalidCipherTextException {
        ECPrivateKeyParameters ecPrivateKeyParameters = Sm2.buildECPrivateKeyParameters(privateKey);
        return Sm2.decrypt(input, ecPrivateKeyParameters, mode);
    }

    public static byte[] decrypt(byte[] input, byte[] privateKey) throws InvalidCipherTextException {
        ECPrivateKeyParameters ecPrivateKeyParameters = Sm2.buildECPrivateKeyParameters(privateKey);
        return Sm2.decrypt(input, ecPrivateKeyParameters, SM2Engine.Mode.C1C2C3);
    }

    public static Sm2Signature sign(byte[] input, ECPrivateKeyParameters ecPrivateKeyParameters, byte[] userId) throws CryptoException {
        SM2Signer signer = new SM2Signer();
        Object param = userId != null && userId.length > 0 ? new ParametersWithID((CipherParameters)ecPrivateKeyParameters, userId) : ecPrivateKeyParameters;
        signer.init(true, (CipherParameters)param);
        signer.update(input, 0, input.length);
        byte[] sign = signer.generateSignature();
        return Sm2Signature.fromStandardDSA(sign);
    }

    public static Sm2Signature sign(byte[] input, byte[] privateKey, byte[] userId) throws CryptoException {
        ECPrivateKeyParameters ecPrivateKeyParameters = Sm2.buildECPrivateKeyParameters(privateKey);
        return Sm2.sign(input, ecPrivateKeyParameters, userId);
    }

    public static boolean verifySign(byte[] input, Sm2Signature signature, ECPublicKeyParameters ecPublicKeyParameters, byte[] userId) throws IOException {
        BigInteger signR = signature.getSignatureR();
        BigInteger signS = signature.getSignatureS();
        byte[] sign = StandardDSAEncoding.INSTANCE.encode(SM2_ECC_N, signR, signS);
        SM2Signer signer = new SM2Signer();
        Object param = userId != null && userId.length > 0 ? new ParametersWithID((CipherParameters)ecPublicKeyParameters, userId) : ecPublicKeyParameters;
        signer.init(false, (CipherParameters)param);
        signer.update(input, 0, input.length);
        return signer.verifySignature(sign);
    }

    public static boolean verifySign(byte[] input, Sm2Signature signature, byte[] publicKey, byte[] userId) throws IOException {
        ECPublicKeyParameters ecPublicKeyParameters = Sm2.buildECPublicKeyParameters(publicKey);
        return Sm2.verifySign(input, signature, ecPublicKeyParameters, userId);
    }

    private static byte[] toCurveLengthBytes(byte[] src) {
        if (src.length == CURVE_LEN) {
            return src;
        }
        byte[] result = new byte[CURVE_LEN];
        if (src.length > CURVE_LEN) {
            System.arraycopy(src, src.length - result.length, result, 0, result.length);
        } else {
            System.arraycopy(src, 0, result, result.length - src.length, src.length);
        }
        return result;
    }

    @Generated
    private Sm2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CURVE = new SM2P256V1Curve();
        SM2_ECC_P = CURVE.getQ();
        SM2_ECC_A = CURVE.getA().toBigInteger();
        SM2_ECC_B = CURVE.getB().toBigInteger();
        SM2_ECC_N = CURVE.getOrder();
        SM2_ECC_H = CURVE.getCofactor();
        SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        G_POINT = CURVE.createPoint(SM2_ECC_GX, SM2_ECC_GY);
        SM2_DOMAIN = new ECDomainParameters((ECCurve)CURVE, G_POINT, SM2_ECC_N, SM2_ECC_H);
        CURVE_LEN = Sm2.getCurveLength(SM2_DOMAIN);
        JDK_CURVE = new EllipticCurve(new ECFieldFp(SM2_ECC_P), SM2_ECC_A, SM2_ECC_B);
        JDK_G_POINT = new ECPoint(G_POINT.getAffineXCoord().toBigInteger(), G_POINT.getAffineYCoord().toBigInteger());
        JDK_EC_SPEC = new ECParameterSpec(JDK_CURVE, JDK_G_POINT, SM2_ECC_N, SM2_ECC_H.intValue());
    }
}

