/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.context;

import cn.dinodev.spring.commons.context.DinoContext;
import cn.dinodev.spring.commons.sys.Tenant;
import cn.dinodev.spring.commons.sys.User;
import java.io.Serializable;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public final class ContextHelper {
    public static final ContextHelper INST = new ContextHelper();
    private static DinoContext context;
    private static ApplicationContext applicationContext;

    private ContextHelper() {
    }

    public static void setApplicationContext(ApplicationContext context) {
        applicationContext = context;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void setDinoContext(DinoContext dinoAppContext) {
        context = dinoAppContext;
    }

    public static DinoContext getDinoContext() {
        return context;
    }

    public static String currentTenantId() {
        Assert.notNull((Object)context, (String)"DinoContext bean not found");
        return context.currentTenant() == null ? null : context.currentTenant().getId();
    }

    public static Tenant currentTenant() {
        Assert.notNull((Object)context, (String)"DinoContext bean not found");
        return context.currentTenant();
    }

    public static <K extends Serializable> User<K> currentUser() {
        Assert.notNull((Object)context, (String)"DinoContext bean not found");
        return context.currentUser();
    }

    public static <T> T findBean(Class<T> requiredType) {
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> T findBean(String name, Class<T> requiredType) {
        return (T)applicationContext.getBean(name, requiredType);
    }
}

