/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.bean;

import cn.dinodev.spring.commons.json.JsonViewUtils;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class Property {
    private static Map<Property, Annotation[]> annotationCache = new ConcurrentReferenceHashMap();
    private final Class<?> objectType;
    @Nullable
    private final Method readMethod;
    @Nullable
    private final Method writeMethod;
    @Nullable
    private final Field field;
    private final String name;
    private final MethodParameter methodParameter;
    @Nullable
    private Annotation[] annotations;

    public Property(Class<?> objectType, @Nullable Method readMethod, @Nullable Method writeMethod) {
        this(objectType, readMethod, writeMethod, null);
    }

    public Property(Class<?> objectType, @Nullable Method readMethod, @Nullable Method writeMethod, @Nullable String name) {
        this.objectType = objectType;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.methodParameter = this.resolveMethodParameter();
        this.name = name != null ? name : this.resolveName();
        this.field = this.resolveField();
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.methodParameter.getParameterType();
    }

    public ResolvableType getResolvableType() {
        if (this.methodParameter != null) {
            return ResolvableType.forMethodParameter((MethodParameter)this.methodParameter);
        }
        if (this.field != null) {
            return ResolvableType.forField((Field)this.field);
        }
        throw new IllegalStateException("No method or field found for property: " + this.name);
    }

    @Nullable
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Nullable
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Nullable
    public Field getField() {
        return this.field;
    }

    public boolean isReadable() {
        return Objects.nonNull(this.readMethod);
    }

    public boolean isWritable() {
        return Objects.nonNull(this.writeMethod);
    }

    public boolean isVisiableInJsonView(@Nullable Class<?> activeView) {
        if (Objects.isNull(activeView) || Objects.isNull(this.annotations)) {
            return true;
        }
        for (Annotation annotation : this.annotations) {
            JsonView jsonView;
            if (!annotation.getClass().equals(JsonView.class) || JsonViewUtils.isInView(activeView, (jsonView = (JsonView)annotation).value())) continue;
            return false;
        }
        return true;
    }

    public boolean isReadableInJsonView(@Nullable Class<?> activeView) {
        if (Objects.isNull(this.readMethod)) {
            return false;
        }
        if (Objects.isNull(activeView)) {
            return true;
        }
        JsonView jsonView = this.getReadAnnotation(JsonView.class);
        return !Objects.nonNull(jsonView) || JsonViewUtils.isInView(activeView, jsonView.value());
    }

    public boolean isWritableInJsonView(@Nullable Class<?> activeView) {
        if (Objects.isNull(this.writeMethod)) {
            return false;
        }
        if (Objects.isNull(activeView)) {
            return true;
        }
        JsonView jsonView = this.getWriteAnnotation(JsonView.class);
        return !Objects.nonNull(jsonView) || JsonViewUtils.isInView(activeView, jsonView.value());
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotations();
        }
        return this.annotations;
    }

    public <A extends Annotation> A getReadAnnotation(Class<A> annotationType) {
        Annotation annon = AnnotationUtils.getAnnotation((Method)this.readMethod, annotationType);
        if (Objects.isNull(annon) && Objects.nonNull(this.field)) {
            annon = AnnotationUtils.getAnnotation((AnnotatedElement)this.field, annotationType);
        }
        return (A)annon;
    }

    public <A extends Annotation> A getWriteAnnotation(Class<A> annotationType) {
        Annotation annon = AnnotationUtils.getAnnotation((Method)this.writeMethod, annotationType);
        if (Objects.isNull(annon) && Objects.nonNull(this.field)) {
            annon = AnnotationUtils.getAnnotation((AnnotatedElement)this.field, annotationType);
        }
        return (A)annon;
    }

    private String resolveName() {
        if (Objects.nonNull(this.readMethod)) {
            String methodName = this.readMethod.getName();
            if (methodName.startsWith("get") && methodName.length() > 3) {
                return StringUtils.uncapitalize((String)methodName.substring(3));
            }
            if (methodName.startsWith("is") && methodName.length() > 2) {
                return StringUtils.uncapitalize((String)methodName.substring(2));
            }
            return StringUtils.uncapitalize((String)methodName);
        }
        if (Objects.nonNull(this.writeMethod)) {
            String methodName = this.writeMethod.getName();
            if (methodName.startsWith("set") && methodName.length() > 3) {
                return StringUtils.uncapitalize((String)methodName.substring(3));
            }
            throw new IllegalArgumentException("Not a setter method");
        }
        throw new IllegalStateException("Property is neither readable nor writeable");
    }

    private MethodParameter resolveMethodParameter() {
        MethodParameter read = this.resolveReadMethodParameter();
        MethodParameter write = this.resolveWriteMethodParameter();
        if (write == null) {
            if (read == null) {
                throw new IllegalStateException("Property is neither readable nor writeable");
            }
            return read;
        }
        if (read != null) {
            Class readType = read.getParameterType();
            Class writeType = write.getParameterType();
            if (!writeType.equals(readType) && writeType.isAssignableFrom(readType)) {
                return read;
            }
        }
        return write;
    }

    @Nullable
    private MethodParameter resolveReadMethodParameter() {
        if (this.getReadMethod() == null) {
            return null;
        }
        return new MethodParameter(this.getReadMethod(), -1).withContainingClass(this.getObjectType());
    }

    @Nullable
    private MethodParameter resolveWriteMethodParameter() {
        if (this.getWriteMethod() == null) {
            return null;
        }
        return new MethodParameter(this.getWriteMethod(), 0).withContainingClass(this.getObjectType());
    }

    private Annotation[] resolveAnnotations() {
        Annotation[] annotations = annotationCache.get(this);
        if (annotations == null) {
            ConcurrentHashMap<Class<? extends Annotation>, Annotation> annotationMap = new ConcurrentHashMap<Class<? extends Annotation>, Annotation>();
            this.addAnnotationsToMap(annotationMap, this.getReadMethod());
            this.addAnnotationsToMap(annotationMap, this.getWriteMethod());
            this.addAnnotationsToMap(annotationMap, this.getField());
            annotations = annotationMap.values().toArray(new Annotation[0]);
            annotationCache.put(this, annotations);
        }
        return annotations;
    }

    private void addAnnotationsToMap(Map<Class<? extends Annotation>, Annotation> annotationMap, @Nullable AnnotatedElement object) {
        if (object != null) {
            for (Annotation annotation : object.getAnnotations()) {
                annotationMap.put(annotation.annotationType(), annotation);
            }
        }
    }

    @Nullable
    private Class<?> declaringClass() {
        if (this.getReadMethod() != null) {
            return this.getReadMethod().getDeclaringClass();
        }
        if (this.getWriteMethod() != null) {
            return this.getWriteMethod().getDeclaringClass();
        }
        return null;
    }

    @Nullable
    private Field resolveField() {
        String name = this.getName();
        if (!StringUtils.hasLength((String)name)) {
            return null;
        }
        Field field = null;
        Class<?> declaringClass = this.declaringClass();
        if (declaringClass != null && (field = ReflectionUtils.findField(declaringClass, (String)name)) == null && (field = ReflectionUtils.findField(declaringClass, (String)StringUtils.uncapitalize((String)name))) == null) {
            field = ReflectionUtils.findField(declaringClass, (String)StringUtils.capitalize((String)name));
        }
        return field;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Property)) return false;
        Property otherProperty = (Property)other;
        if (!ObjectUtils.nullSafeEquals(this.objectType, otherProperty.objectType)) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.name, (Object)otherProperty.name)) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.readMethod, (Object)otherProperty.readMethod)) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.writeMethod, (Object)otherProperty.writeMethod)) return false;
        return true;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.objectType) * 31 + ObjectUtils.nullSafeHashCode((Object)this.name);
    }
}

