/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.bean;

import cn.dinodev.spring.commons.bean.BeanMeta;
import cn.dinodev.spring.commons.bean.Property;
import java.util.Arrays;
import java.util.Objects;

public class BeanMetaWithJsonView
implements BeanMeta {
    private final BeanMeta beanMeta;
    private final Class<?> activeView;

    public BeanMetaWithJsonView(BeanMeta beanMeta, Class<?> activeView) {
        this.beanMeta = beanMeta;
        this.activeView = activeView;
    }

    public Class<?> getActiveView() {
        return this.activeView;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanMeta.getBeanClass();
    }

    @Override
    public String[] getPropertyNames() {
        Property[] pds = this.beanMeta.getProperties();
        return (String[])Arrays.stream(pds).filter(p -> p.isVisiableInJsonView(this.activeView)).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getProperties() {
        Property[] pds = this.beanMeta.getProperties();
        return (Property[])Arrays.stream(pds).filter(p -> p.isVisiableInJsonView(this.activeView)).toArray(Property[]::new);
    }

    @Override
    public Property getProperty(String propertyName) {
        Property pd = this.beanMeta.getProperty(propertyName);
        if (Objects.nonNull(pd) && pd.isVisiableInJsonView(this.activeView)) {
            return pd;
        }
        return null;
    }

    @Override
    public Property[] getReadableProperties() {
        Property[] pds = this.beanMeta.getProperties();
        return (Property[])Arrays.stream(pds).filter(p -> p.isReadableInJsonView(this.activeView)).toArray(Property[]::new);
    }

    @Override
    public Property[] getWritableProperties() {
        Property[] pds = this.beanMeta.getProperties();
        return (Property[])Arrays.stream(pds).filter(p -> p.isWritableInJsonView(this.activeView)).toArray(Property[]::new);
    }

    @Override
    public String[] getReadablePropertyNames() {
        Property[] pds = this.beanMeta.getProperties();
        return (String[])Arrays.stream(pds).filter(p -> p.isReadableInJsonView(this.activeView)).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public String[] getWritablePropertyNames() {
        Property[] pds = this.beanMeta.getProperties();
        return (String[])Arrays.stream(pds).filter(p -> p.isWritableInJsonView(this.activeView)).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public String[] getUnreadablePropertyNames() {
        Property[] pds = this.beanMeta.getProperties();
        return (String[])Arrays.stream(pds).filter(p -> !p.isReadableInJsonView(this.activeView)).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getUnreadableProperties() {
        Property[] pds = this.beanMeta.getProperties();
        return (Property[])Arrays.stream(pds).filter(p -> !p.isReadableInJsonView(this.activeView)).toArray(Property[]::new);
    }

    @Override
    public String[] getUnwritablePropertyNames() {
        Property[] pds = this.beanMeta.getProperties();
        return (String[])Arrays.stream(pds).filter(p -> !p.isWritableInJsonView(this.activeView)).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getUnwritableProperties() {
        Property[] pds = this.beanMeta.getProperties();
        return (Property[])Arrays.stream(pds).filter(p -> !p.isWritableInJsonView(this.activeView)).toArray(Property[]::new);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BeanMetaWithJsonView)) {
            return false;
        }
        return this.beanMeta.equals(((BeanMetaWithJsonView)obj).beanMeta) && this.activeView.equals(((BeanMetaWithJsonView)obj).activeView);
    }

    public int hashCode() {
        int hashCode = this.beanMeta.hashCode();
        hashCode = 29 * hashCode + this.activeView.hashCode();
        return hashCode;
    }
}

