/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.bean;

import cn.dinodev.spring.commons.bean.BeanMeta;
import cn.dinodev.spring.commons.bean.Property;
import cn.dinodev.spring.commons.function.Suppliers;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;

public class BeanMetaImpl
implements BeanMeta {
    private final Class<?> beanClass;
    private final Supplier<Map<String, Property>> propertyDescriptorsSupplier;

    public BeanMetaImpl(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.propertyDescriptorsSupplier = Suppliers.lazy(() -> {
            PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(this.beanClass);
            ConcurrentHashMap<String, Property> map = new ConcurrentHashMap<String, Property>(pds.length);
            for (PropertyDescriptor propertyDescriptor : pds) {
                map.put(propertyDescriptor.getName(), new Property(this.beanClass, propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod(), propertyDescriptor.getName()));
            }
            return map;
        });
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Property getProperty(String propertyName) {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return pds.get(propertyName);
    }

    @Override
    public Property[] getProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return pds.values().toArray(new Property[0]);
    }

    @Override
    public String[] getPropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().map(Property::getName).toArray(String[]::new);
    }

    @Override
    public String[] getReadablePropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().filter(p -> Objects.nonNull(p.getReadMethod())).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getReadableProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (Property[])pds.values().stream().filter(p -> Objects.nonNull(p.getReadMethod())).toArray(Property[]::new);
    }

    @Override
    public String[] getWritablePropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().filter(p -> Objects.nonNull(p.getWriteMethod())).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getWritableProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (Property[])pds.values().stream().filter(p -> Objects.nonNull(p.getWriteMethod())).toArray(Property[]::new);
    }

    @Override
    public String[] getUnreadablePropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().filter(p -> Objects.isNull(p.getReadMethod())).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getUnreadableProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (Property[])pds.values().stream().filter(p -> Objects.isNull(p.getReadMethod())).toArray(Property[]::new);
    }

    @Override
    public String[] getUnwritablePropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().filter(p -> Objects.isNull(p.getWriteMethod())).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getUnwritableProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (Property[])pds.values().stream().filter(p -> Objects.isNull(p.getWriteMethod())).toArray(Property[]::new);
    }

    public boolean equals(Object obj) {
        return obj instanceof BeanMetaImpl && ((BeanMetaImpl)obj).beanClass.equals(this.beanClass);
    }

    public int hashCode() {
        return this.getBeanClass().hashCode();
    }
}

