/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.autoconfig;

import cn.dinodev.spring.commons.context.ContextHelper;
import cn.dinodev.spring.commons.context.DinoContext;
import cn.dinodev.spring.commons.context.DinoContextThreadLocalImpl;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.lang.NonNull;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class DinoCommonsAutoConfiguration
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DinoCommonsAutoConfiguration.class);

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        if (ContextHelper.getApplicationContext() == null) {
            log.info("--->> setup ContextHelper with applicationContext[id={}]", (Object)applicationContext.getId());
            ContextHelper.setApplicationContext(applicationContext);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public DinoContext dinoContext() {
        log.info("--->> use defalut dinoContext[class={}]", DinoContextThreadLocalImpl.class);
        return new DinoContextThreadLocalImpl();
    }

    @Bean
    @Lazy(value=false)
    @ConditionalOnMissingBean
    public ContextHelper contextHelper(DinoContext dinoContext) {
        log.info("--->> setup ContextHelper with dinoContext[class={}]", dinoContext.getClass());
        ContextHelper.setDinoContext(dinoContext);
        return ContextHelper.INST;
    }
}

