/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public interface Scope
extends Serializable {
    public String getName();

    public int getOrder();

    public Scope[] lowerScopes(boolean var1);

    public Scope[] higherScopes(boolean var1);

    public static enum DEFAULT implements Scope
    {
        SYS("sys", 0),
        TENANT("tenant", 1),
        PAGE("page", 2),
        USER("user", 3);

        private static final Scope[] EMPTY_ARRAY;
        private String name;
        private int order;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public Scope[] lowerScopes(boolean includeThis) {
            return Arrays.stream(DEFAULT.values()).filter(s -> s.getOrder() < this.getOrder() || includeThis && s.getOrder() == this.getOrder()).collect(Collectors.toList()).toArray(EMPTY_ARRAY);
        }

        @Override
        public Scope[] higherScopes(boolean includeThis) {
            return Arrays.stream(DEFAULT.values()).filter(s -> s.getOrder() > this.getOrder() || includeThis && s.getOrder() == this.getOrder()).collect(Collectors.toList()).toArray(EMPTY_ARRAY);
        }

        public String toString() {
            return this.name;
        }

        public static Function<String, Scope> provider() {
            return DEFAULT::of;
        }

        public static Scope of(String name) {
            return DEFAULT.valueOf(name.toUpperCase());
        }

        @Generated
        private DEFAULT(String name, int order) {
            this.name = name;
            this.order = order;
        }

        static {
            EMPTY_ARRAY = new Scope[0];
        }
    }
}

