/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.validation.validator;

import cn.dinodev.spring.commons.validation.constraints.PasswordStrength;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class PasswordStrengthValidator
implements ConstraintValidator<PasswordStrength, String> {
    private PasswordChecker[] checkers;

    public void initialize(PasswordStrength constraintAnnotation) {
        switch (constraintAnnotation.format()) {
            case NUMERIC: {
                this.checkers = new PasswordChecker[]{PasswordChecker.NUMERIC};
                break;
            }
            case NUMERIC_SPECIAL_CHARACTER: {
                this.checkers = new PasswordChecker[]{PasswordChecker.NUMERIC, PasswordChecker.SPECIAL_CHARACTER};
                break;
            }
            case LETTER: {
                this.checkers = PasswordStrengthValidator.letterChecker(constraintAnnotation.letterType());
                break;
            }
            case NUMERIC_LETTER: {
                this.checkers = (PasswordChecker[])ArrayUtils.addAll((Object[])PasswordStrengthValidator.letterChecker(constraintAnnotation.letterType()), (Object[])new PasswordChecker[]{PasswordChecker.NUMERIC});
                break;
            }
            case LETTER_SPECIAL_CHARACTER: {
                this.checkers = (PasswordChecker[])ArrayUtils.addAll((Object[])PasswordStrengthValidator.letterChecker(constraintAnnotation.letterType()), (Object[])new PasswordChecker[]{PasswordChecker.SPECIAL_CHARACTER});
                break;
            }
            case NUMERIC_LETTER_SPECIAL_CHARACTER: {
                this.checkers = (PasswordChecker[])ArrayUtils.addAll((Object[])PasswordStrengthValidator.letterChecker(constraintAnnotation.letterType()), (Object[])new PasswordChecker[]{PasswordChecker.NUMERIC, PasswordChecker.SPECIAL_CHARACTER});
                break;
            }
            default: {
                this.checkers = new PasswordChecker[0];
            }
        }
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        boolean[] checkHits = new boolean[this.checkers.length];
        Arrays.fill(checkHits, false);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            for (int j = 0; j < this.checkers.length; ++j) {
                if (!this.checkers[j].check(c)) continue;
                checkHits[j] = true;
            }
        }
        return !ArrayUtils.contains((boolean[])checkHits, (boolean)false);
    }

    private static PasswordChecker[] letterChecker(PasswordStrength.LetterType type) {
        switch (type) {
            case ANY: {
                return new PasswordChecker[]{PasswordChecker.LETTER};
            }
            case LOWER: {
                return new PasswordChecker[]{PasswordChecker.LETTER_LOWER};
            }
            case UPPER: {
                return new PasswordChecker[]{PasswordChecker.LETTER_UPPER};
            }
        }
        return new PasswordChecker[]{PasswordChecker.LETTER_LOWER, PasswordChecker.LETTER_UPPER};
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum PasswordChecker {
        NUMERIC{

            @Override
            boolean check(char ch) {
                return Character.isDigit(ch);
            }
        }
        ,
        LETTER{

            @Override
            boolean check(char ch) {
                return Character.isLowerCase(ch) || Character.isUpperCase(ch);
            }
        }
        ,
        LETTER_LOWER{

            @Override
            boolean check(char ch) {
                return Character.isLowerCase(ch);
            }
        }
        ,
        LETTER_UPPER{

            @Override
            boolean check(char ch) {
                return Character.isUpperCase(ch);
            }
        }
        ,
        SPECIAL_CHARACTER{

            @Override
            boolean check(char ch) {
                return Arrays.binarySearch(SYMBOLS, ch) >= 0;
            }
        };

        private static final char[] SYMBOLS;

        abstract boolean check(char var1);

        static {
            SYMBOLS = ")!@#$%^&*()".toCharArray();
            Arrays.sort(SYMBOLS);
        }
    }
}

