/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.validation.validator;

import cn.dinodev.spring.commons.validation.constraints.Ip;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IpValidator
implements ConstraintValidator<Ip, String> {
    private static final Pattern PATTERN_V4 = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final Pattern PATTERN_V6 = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private Ip.IpVersion ver;

    public void initialize(Ip constraintAnnotation) {
        this.ver = constraintAnnotation.version();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        if (this.ver == Ip.IpVersion.IPV4) {
            return PATTERN_V4.matcher(value).matches();
        }
        if (this.ver == Ip.IpVersion.IPV6) {
            return PATTERN_V6.matcher(value).matches();
        }
        return PATTERN_V4.matcher(value).matches() || PATTERN_V6.matcher(value).matches();
    }
}

