/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import lombok.Generated;
import org.springframework.core.ResolvableType;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public final class TypeUtils {
    public static <T> Class<T> getGenericParamClass(Type actualType, Class<?> contextType, int paramIndex) {
        ResolvableType resolvedType = TypeUtils.resolveGenericParamType(ResolvableType.forType((Type)actualType), contextType);
        if (resolvedType == null || !resolvedType.hasGenerics()) {
            return null;
        }
        return (Class)TypeUtils.cast(resolvedType.getGeneric(new int[]{paramIndex}).resolve());
    }

    public static ResolvableType resolveGenericParamType(ResolvableType actualType, Class<?> interfaceType) {
        ResolvableType ret;
        Class actualClass = actualType.resolve();
        if (actualClass == null || !interfaceType.isAssignableFrom(actualType.resolve())) {
            return null;
        }
        if (actualClass.equals(interfaceType)) {
            return actualType;
        }
        ResolvableType superType = actualType.getSuperType();
        if (superType != ResolvableType.NONE && Objects.nonNull(ret = TypeUtils.resolveGenericParamType(superType, interfaceType))) {
            return (ResolvableType)TypeUtils.cast(ret);
        }
        for (ResolvableType ifc : actualType.getInterfaces()) {
            ResolvableType ret2 = TypeUtils.resolveGenericParamType(ifc, interfaceType);
            if (!Objects.nonNull(ret2)) continue;
            return (ResolvableType)TypeUtils.cast(ret2);
        }
        return null;
    }

    public static <T> Class<T> getGenericParamClass(Object inst, Class<?> contextType, int paramIndex) {
        ResolvableType resolvedType = TypeUtils.resolveGenericParamType(ResolvableType.forClass(inst.getClass()), contextType);
        if (resolvedType == null || !resolvedType.hasGenerics()) {
            return null;
        }
        return (Class)TypeUtils.cast(resolvedType.getGeneric(new int[]{paramIndex}).resolve());
    }

    public static <T> Class<T> getGenericSuperclassParamClass(Object inst, Class<?> interfaceClass, int paramIndex) {
        ParameterizedType tp;
        Type type = inst.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType && (tp = (ParameterizedType)type).getRawType().equals(interfaceClass)) {
            Type t = tp.getActualTypeArguments()[paramIndex];
            if (t instanceof ParameterizedType) {
                return (Class)((ParameterizedType)t).getRawType();
            }
            return (Class)t;
        }
        return null;
    }

    public static boolean isPrimitiveOrString(@Nonnull Class<?> clazz) {
        return ClassUtils.isPrimitiveOrWrapper(clazz) || clazz == String.class;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static boolean isInstanceOfAny(Object instance, Type ... types) {
        for (Type type : types) {
            if (!org.apache.commons.lang3.reflect.TypeUtils.isInstance((Object)instance, (Type)type)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> T cast(@Nullable Object object) {
        return (T)object;
    }

    @NonNull
    public static <T> T castNonNull(@Nullable Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (T)object;
    }

    @Generated
    private TypeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

