/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import cn.dinodev.spring.commons.utils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class InheritableThreadLocalMap
extends InheritableThreadLocal<Map<String, Object>> {
    @Override
    protected Map<String, Object> childValue(Map<String, Object> parentValue) {
        return (Map)ObjectUtils.clone(parentValue);
    }

    private synchronized void ensureResourcesInitialized() {
        if (this.get() == null) {
            this.set(new HashMap(4));
        }
    }

    public void put(String key, Object value) {
        this.ensureResourcesInitialized();
        ((Map)this.get()).put(key, value);
    }

    public <T> T get(String key) {
        this.ensureResourcesInitialized();
        return TypeUtils.cast(((Map)this.get()).get(key));
    }

    public <T> T getOrDefault(String key, T defaultValue) {
        this.ensureResourcesInitialized();
        return TypeUtils.cast(((Map)this.get()).getOrDefault(key, defaultValue));
    }

    public void remove(String key) {
        this.ensureResourcesInitialized();
        ((Map)this.get()).remove(key);
    }

    public void clear() {
        this.set(null);
    }
}

