/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import cn.dinodev.spring.commons.exception.BusinessException;
import cn.dinodev.spring.commons.response.Status;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.helpers.MessageFormatter;

public final class Assert {
    public static void state(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        }
    }

    public static void state(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalStateException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isTrue(boolean expression, String message) {
        Assert.isTrue(expression, Status.fail(message));
    }

    public static void isTrue(boolean expression, Status status) {
        if (!expression) {
            throw BusinessException.of(status);
        }
    }

    public static void isTrue(boolean expression, @Nonnull Supplier<Status> statusSupplier) {
        if (!expression) {
            throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void isNull(@Nullable Object object, String message) {
        Assert.isNull(object, Status.fail(message));
    }

    public static void isNull(@Nullable Object object, Status status) {
        if (!Objects.isNull(object)) {
            throw BusinessException.of(status);
        }
    }

    public static void isNull(@Nullable Object object, @Nonnull Supplier<Status> statusSupplier) {
        if (!Objects.isNull(object)) {
            throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void notNull(@Nullable Object object, String message, Object ... msgArgs) {
        Assert.notNull(object, Status.fail(MessageFormatter.arrayFormat((String)message, (Object[])msgArgs).getMessage()));
    }

    public static void notNull(@Nullable Object object, Status status) {
        if (Objects.isNull(object)) {
            throw BusinessException.of(status);
        }
    }

    public static void notNull(@Nullable Object object, @Nonnull Supplier<Status> statusSupplier) {
        if (Objects.isNull(object)) {
            throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void hasLength(@Nullable CharSequence text, String message) {
        Assert.hasLength(text, Status.fail(message));
    }

    public static void hasLength(@Nullable CharSequence text, Status status) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw BusinessException.of(status);
        }
    }

    public static void hasLength(@Nullable CharSequence text, @Nonnull Supplier<Status> statusSupplier) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void hasText(@Nullable CharSequence text, String message) {
        Assert.hasText(text, Status.fail(message));
    }

    public static void hasText(@Nullable CharSequence text, Status status) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw BusinessException.of(status);
        }
    }

    public static void hasText(@Nullable CharSequence text, @Nonnull Supplier<Status> statusSupplier) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, String message) {
        Assert.doesNotContain(textToSearch, substring, Status.fail(message));
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, Status status) {
        if (StringUtils.isNotEmpty((CharSequence)textToSearch) && StringUtils.isNotEmpty((CharSequence)substring) && textToSearch.contains(substring)) {
            throw BusinessException.of(status);
        }
    }

    public static void doesNotContain(@Nullable String textToSearch, @Nonnull String substring, @Nonnull Supplier<Status> statusSupplier) {
        if (StringUtils.isNotEmpty((CharSequence)textToSearch) && StringUtils.isNotEmpty((CharSequence)substring) && textToSearch.contains(substring)) {
            throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void notEmpty(@Nullable Object[] array, String message) {
        Assert.notEmpty(array, Status.fail(message));
    }

    public static void notEmpty(@Nullable Object[] array, Status status) {
        if (array == null || array.length == 0) {
            throw BusinessException.of(status);
        }
    }

    public static void notEmpty(@Nullable Object[] array, @Nonnull Supplier<Status> statusSupplier) {
        if (array == null || array.length == 0) {
            throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void noNullElements(@Nullable Object[] array, String message) {
        Assert.noNullElements(array, Status.fail(message));
    }

    public static void noNullElements(@Nullable Object[] array, Status status) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw BusinessException.of(status);
            }
        }
    }

    public static void noNullElements(@Nullable Object[] array, @Nonnull Supplier<Status> statusSupplier) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
            }
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, String message) {
        Assert.notEmpty(collection, Status.fail(message));
    }

    public static void notEmpty(@Nullable Collection<?> collection, Status status) {
        if (CollectionUtils.isEmpty(collection)) {
            throw BusinessException.of(status);
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, @Nonnull Supplier<Status> statusSupplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, String message) {
        Assert.noNullElements(collection, Status.fail(message));
    }

    public static void noNullElements(@Nullable Collection<?> collection, String message, Object ... msgArgs) {
        Assert.noNullElements(collection, Status.fail(MessageFormatter.arrayFormat((String)message, (Object[])msgArgs).getMessage()));
    }

    public static void noNullElements(@Nullable Collection<?> collection, Status status) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw BusinessException.of(status);
            }
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, @Nonnull Supplier<Status> statusSupplier) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
            }
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map, String message) {
        Assert.notEmpty(map, Status.fail(message));
    }

    public static void notEmpty(@Nullable Map<?, ?> map, String message, Object ... msgArgs) {
        Assert.notEmpty(map, Status.fail(MessageFormatter.arrayFormat((String)message, (Object[])msgArgs).getMessage()));
    }

    public static void notEmpty(@Nullable Map<?, ?> map, Status status) {
        if (MapUtils.isEmpty(map)) {
            throw BusinessException.of(status);
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map, @Nonnull Supplier<Status> statusSupplier) {
        if (MapUtils.isEmpty(map)) {
            throw BusinessException.of(Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void isInstanceOf(@Nonnull Class<?> type, @Nullable Object obj, String message) {
        Assert.isInstanceOf(type, obj, Status.fail(message));
    }

    public static void isInstanceOf(@Nonnull Class<?> type, @Nullable Object obj, Status status) {
        if (!type.isInstance(obj)) {
            Assert.instanceCheckFailed(type, obj, status);
        }
    }

    public static void isInstanceOf(@Nonnull Class<?> type, @Nullable Object obj, @Nonnull Supplier<Status> statusSupplier) {
        if (!type.isInstance(obj)) {
            Assert.instanceCheckFailed(type, obj, Assert.nullSafeGet(statusSupplier));
        }
    }

    public static void isAssignable(@Nonnull Class<?> superType, @Nullable Class<?> subType, String message) {
        Assert.isAssignable(superType, subType, Status.fail(message));
    }

    public static void isAssignable(@Nonnull Class<?> superType, @Nullable Class<?> subType, Status status) {
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Assert.assignableCheckFailed(superType, subType, status);
        }
    }

    public static void isAssignable(@Nonnull Class<?> superType, @Nullable Class<?> subType, @Nonnull Supplier<Status> statusSupplier) {
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Assert.assignableCheckFailed(superType, subType, Assert.nullSafeGet(statusSupplier));
        }
    }

    private static void instanceCheckFailed(Class<?> type, @Nullable Object obj, @Nonnull Status status) {
        String msg = status.getMsg();
        String className = obj != null ? obj.getClass().getName() : "null";
        Object result = "";
        boolean defaultMessage = true;
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = Assert.messageWithTypeName(msg, className);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = (String)result + "Object of class [" + className + "] must be an instance of " + type;
        }
        throw BusinessException.of(Status.fail(status.getCode(), (String)result));
    }

    private static void assignableCheckFailed(Class<?> superType, @Nullable Class<?> subType, @Nonnull Status status) {
        String msg = status.getMsg();
        Object result = "";
        boolean defaultMessage = true;
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = Assert.messageWithTypeName(msg, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = (String)result + subType + " is not assignable to " + superType;
        }
        throw BusinessException.of(Status.fail(status.getCode(), (String)result));
    }

    private static boolean endsWithSeparator(String msg) {
        return msg.endsWith(":") || msg.endsWith(";") || msg.endsWith(",") || msg.endsWith(".");
    }

    private static String messageWithTypeName(String msg, @Nullable Object typeName) {
        return msg + (msg.endsWith(" ") ? "" : ": ") + typeName;
    }

    @Nullable
    private static <T> T nullSafeGet(@Nullable Supplier<T> messageSupplier) {
        return messageSupplier != null ? (T)messageSupplier.get() : null;
    }

    @Generated
    private Assert() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

