/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.response;

import cn.dinodev.spring.commons.response.Status;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import lombok.Generated;

@ApiResponse(description="restApi\u54cd\u5e94", content={@Content(mediaType="application/json")})
public class Response<T> {
    @Schema(description="\u54cd\u5e94\u72b6\u6001\u7801:0\u4e3a\u6210\u529f,\u5176\u4ed6\u7801\u503c\u4e3a\u5931\u8d25", required=true, example="0")
    private Integer code;
    @Schema(description="\u54cd\u5e94\u63d0\u793a\u4fe1\u606f:\u6210\u529f\u4e3asuccess,\u5176\u4f59\u4e3a\u5bf9\u5e94\u7684\u9519\u8bef\u4fe1\u606f", example="success")
    private String msg;
    @Schema(description="\u4e1a\u52a1\u54cd\u5e94\u6570\u636e")
    private T data;
    @Schema(description="\u54cd\u5e94\u8017\u65f6(\u6beb\u79d2)", required=true, example="50")
    private Long cost;

    protected Response() {
        this.code = 0;
        this.msg = "success";
    }

    protected Response(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static <T> Response<T> success() {
        return new Response<T>(0, "success");
    }

    public static <T> Response<T> success(T data) {
        Response<T> resp = Response.success();
        resp.setData(data);
        return resp;
    }

    public static <T> Response<T> fail(String msg) {
        return new Response<T>(Status.CODE.ERROR.getCode(), msg);
    }

    public static <T> Response<T> fail(Status status) {
        return new Response<T>(status.getCode(), status.getMsg());
    }

    @Generated
    public Integer getCode() {
        return this.code;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public Long getCost() {
        return this.cost;
    }

    @Generated
    public Response<T> setCode(Integer code) {
        this.code = code;
        return this;
    }

    @Generated
    public Response<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    @Generated
    public Response<T> setData(T data) {
        this.data = data;
        return this;
    }

    @Generated
    public Response<T> setCost(Long cost) {
        this.cost = cost;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Long this$cost = this.getCost();
        Long other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Long $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Response(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", cost=" + this.getCost() + ")";
    }
}

