/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.response;

import cn.dinodev.spring.commons.response.Response;
import cn.dinodev.spring.commons.response.Status;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

@Schema(description="restApi\u5206\u9875\u54cd\u5e94")
public class PageResponse<T>
extends Response<Collection<? extends T>> {
    @Schema(description="\u6570\u636e\u603b\u6761\u6570")
    private Long total;
    @Schema(description="\u672c\u6b21\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u6761\u6570")
    private Integer count;
    @Schema(description="\u672c\u6b21\u67e5\u8be2\u9875\u7801\uff1a\u4ece0\u5f00\u59cb", example="0")
    private Integer pn;
    @Schema(description="\u6bcf\u9875\u6570\u636e\u6761\u6570")
    private Integer pl;

    protected PageResponse(int code, String msg) {
        super(code, msg);
        this.total = 0L;
        this.count = 0;
    }

    protected PageResponse(int pn, int pl) {
        this.total = 0L;
        this.count = 0;
        this.pn = pn;
        this.pl = pl;
    }

    protected PageResponse(Collection<? extends T> list, Long total, Integer pn, Integer pl) {
        this.total = total;
        this.pn = pn;
        this.pl = pl;
        this.setData(list);
    }

    public PageResponse<T> set(Collection<? extends T> list, Long total) {
        this.setData(list);
        this.setTotal(total);
        return this;
    }

    @Override
    public Response<Collection<? extends T>> setData(Collection<? extends T> list) {
        this.count = list == null ? 0 : list.size();
        return super.setData(list);
    }

    @Schema(description="\u6570\u636e\u603b\u9875\u6570")
    public Long getTotalPage() {
        if (null != this.total && null != this.pl && this.pl > 0) {
            return (this.total + (long)this.pl.intValue() - 1L) / (long)this.pl.intValue();
        }
        return 0L;
    }

    public static <T> PageResponse<T> success(Page<T> page) {
        return new PageResponse<T>(page.getContent(), page.getTotalElements(), page.getNumber(), page.getSize());
    }

    public static <T, S> PageResponse<T> success(Page<S> page, Function<Collection<S>, Collection<? extends T>> converter) {
        return new PageResponse<T>(converter.apply(page.getContent()), page.getTotalElements(), page.getPageable().getPageNumber(), page.getPageable().getPageSize());
    }

    public static <T> PageResponse<T> success(int pn, int pl) {
        return new PageResponse<T>(pn, pl);
    }

    public static <T> PageResponse<T> success(int pn, int pl, Collection<T> list, Long totalCount) {
        return new PageResponse<T>(list, totalCount, pn, pl);
    }

    public static <T> PageResponse<T> success(Pageable page, Collection<T> list, Long totalCount) {
        return new PageResponse<T>(list, totalCount, page.getPageNumber(), page.getPageSize());
    }

    public static <T> PageResponse<T> failPage(String msg) {
        return new PageResponse<T>(Status.CODE.ERROR.getCode(), msg);
    }

    public static <T> PageResponse<T> failPage(Status status) {
        return new PageResponse<T>(status.getCode(), status.getMsg());
    }

    @Generated
    public Long getTotal() {
        return this.total;
    }

    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public Integer getPn() {
        return this.pn;
    }

    @Generated
    public Integer getPl() {
        return this.pl;
    }

    @Generated
    public PageResponse<T> setTotal(Long total) {
        this.total = total;
        return this;
    }

    @Generated
    public PageResponse<T> setCount(Integer count) {
        this.count = count;
        return this;
    }

    @Generated
    public PageResponse<T> setPn(Integer pn) {
        this.pn = pn;
        return this;
    }

    @Generated
    public PageResponse<T> setPl(Integer pl) {
        this.pl = pl;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "PageResponse(total=" + this.getTotal() + ", count=" + this.getCount() + ", pn=" + this.getPn() + ", pl=" + this.getPl() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResponse)) {
            return false;
        }
        PageResponse other = (PageResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Integer this$pn = this.getPn();
        Integer other$pn = other.getPn();
        if (this$pn == null ? other$pn != null : !((Object)this$pn).equals(other$pn)) {
            return false;
        }
        Integer this$pl = this.getPl();
        Integer other$pl = other.getPl();
        return !(this$pl == null ? other$pl != null : !((Object)this$pl).equals(other$pl));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Integer $pn = this.getPn();
        result = result * 59 + ($pn == null ? 43 : ((Object)$pn).hashCode());
        Integer $pl = this.getPl();
        result = result * 59 + ($pl == null ? 43 : ((Object)$pl).hashCode());
        return result;
    }
}

