/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.promise;

import cn.dinodev.spring.commons.promise.AlwaysCallback;
import cn.dinodev.spring.commons.promise.Promise;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPromise<D>
implements Promise<D> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPromise.class);
    protected volatile Promise.State state = Promise.State.PENDING;
    protected final List<Consumer<? super D>> doneCallbacks = new CopyOnWriteArrayList<Consumer<? super D>>();
    protected final List<Consumer<Throwable>> failCallbacks = new CopyOnWriteArrayList<Consumer<Throwable>>();
    protected final List<AlwaysCallback<? super D>> alwaysCallbacks = new CopyOnWriteArrayList<AlwaysCallback<? super D>>();
    protected D resolveResult;
    protected Throwable rejectResult;

    @Override
    public Promise.State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<D> done(Consumer<? super D> callback) {
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            if (this.isResolved()) {
                this.triggerDone(callback, this.resolveResult);
            } else {
                this.doneCallbacks.add(callback);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<D> fail(Consumer<Throwable> callback) {
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            if (this.isRejected()) {
                this.triggerFail(callback, this.rejectResult);
            } else {
                this.failCallbacks.add(callback);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<D> always(AlwaysCallback<? super D> callback) {
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            if (this.isPending()) {
                this.alwaysCallbacks.add(callback);
            } else {
                this.triggerAlways(callback, this.state, this.resolveResult, this.rejectResult);
            }
        }
        return this;
    }

    protected void triggerDone(D resolved) {
        for (Consumer<? super D> consumer : this.doneCallbacks) {
            this.triggerDone(consumer, resolved);
        }
        this.doneCallbacks.clear();
    }

    protected void triggerDone(Consumer<? super D> callback, D resolved) {
        try {
            callback.accept(resolved);
        }
        catch (Exception e) {
            this.handleException(CallbackType.DONE_CALLBACK, e);
        }
    }

    protected void triggerFail(Throwable rejected) {
        for (Consumer<Throwable> callback : this.failCallbacks) {
            this.triggerFail(callback, rejected);
        }
        this.failCallbacks.clear();
    }

    protected void triggerFail(Consumer<Throwable> callback, Throwable rejected) {
        try {
            callback.accept(rejected);
        }
        catch (Exception e) {
            this.handleException(CallbackType.FAIL_CALLBACK, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerAlways(Promise.State state, D resolve, Throwable reject) {
        for (AlwaysCallback<? super D> alwaysCallback : this.alwaysCallbacks) {
            this.triggerAlways(alwaysCallback, state, resolve, reject);
        }
        this.alwaysCallbacks.clear();
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            this.notifyAll();
        }
    }

    protected void triggerAlways(AlwaysCallback<? super D> callback, Promise.State state, D resolve, Throwable reject) {
        try {
            callback.onAlways(state, resolve, reject);
        }
        catch (Exception e) {
            this.handleException(CallbackType.ALWAYS_CALLBACK, e);
        }
    }

    @Override
    public Promise<D> then(Consumer<? super D> callback) {
        return this.done(callback);
    }

    @Override
    public Promise<D> then(Consumer<? super D> doneCallback, Consumer<Throwable> failCallback) {
        this.done(doneCallback);
        this.fail(failCallback);
        return this;
    }

    @Override
    public boolean isPending() {
        return this.state == Promise.State.PENDING;
    }

    @Override
    public boolean isResolved() {
        return this.state == Promise.State.RESOLVED;
    }

    @Override
    public boolean isRejected() {
        return this.state == Promise.State.REJECTED;
    }

    @Override
    public void waitSafely() throws InterruptedException {
        this.waitSafely(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitSafely(long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            while (this.isPending()) {
                try {
                    if (timeout <= 0L) {
                        this.wait();
                    } else {
                        long elapsed = System.currentTimeMillis() - startTime;
                        long waitTime = timeout - elapsed;
                        this.wait(waitTime);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
                if (timeout <= 0L || System.currentTimeMillis() - startTime < timeout) continue;
                return;
            }
        }
    }

    @Override
    public D get() {
        try {
            this.waitSafely();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.isResolved()) {
            return this.resolveResult;
        }
        if (this.isRejected()) {
            throw new RuntimeException(this.rejectResult);
        }
        return this.resolveResult;
    }

    @Override
    public D getOrElse(D defaultValue) {
        try {
            this.waitSafely();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isResolved()) {
            return this.resolveResult;
        }
        return defaultValue;
    }

    @Override
    public D getOrElse(Supplier<D> valueSupplier) {
        try {
            this.waitSafely();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isResolved()) {
            return this.resolveResult;
        }
        return valueSupplier.get();
    }

    protected void handleException(CallbackType callbackType, Exception e) {
        log.error("An uncaught exception occurred  in {}", (Object)callbackType, (Object)e);
    }

    protected static enum CallbackType {
        DONE_CALLBACK,
        FAIL_CALLBACK,
        PROGRESS_CALLBACK,
        ALWAYS_CALLBACK;

    }
}

