/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.json;

import cn.dinodev.spring.commons.json.annotation.JsonDiscriminator;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.util.Objects;

public class JsonDiscriminatorModule
extends SimpleModule {
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.insertAnnotationIntrospector((AnnotationIntrospector)new JsonDiscriminatorAnnotationIntrospector());
    }

    public static class JsonDiscriminatorAnnotationIntrospector
    extends AnnotationIntrospector {
        public Version version() {
            return VersionUtil.parseVersion((String)"2.2.0", (String)"cn.dinodev.spring", (String)"dino-spring-commons");
        }

        public boolean isAnnotationBundle(Annotation ann) {
            return ann.annotationType().equals(JsonDiscriminator.class);
        }

        public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass am, JavaType baseType) {
            TypeIdResolver idRes;
            if (baseType.isContainerType() || baseType.isReferenceType()) {
                return null;
            }
            JsonDiscriminator jd = (JsonDiscriminator)this._findAnnotation((Annotated)am, JsonDiscriminator.class);
            if (Objects.isNull(jd)) {
                return null;
            }
            JsonTypeInfo info = jd.annotationType().getAnnotation(JsonTypeInfo.class);
            JsonTypeIdResolver idResInfo = jd.annotationType().getAnnotation(JsonTypeIdResolver.class);
            TypeIdResolver typeIdResolver = idRes = idResInfo == null ? null : (TypeIdResolver)ClassUtil.createInstance((Class)idResInfo.value(), (boolean)config.canOverrideAccessModifiers());
            if (idRes != null) {
                idRes.init(baseType);
            }
            StdTypeResolverBuilder builder = new StdTypeResolverBuilder();
            builder = builder.init(info.use(), idRes);
            JsonTypeInfo.As inclusion = info.include();
            if (inclusion == JsonTypeInfo.As.EXTERNAL_PROPERTY) {
                inclusion = JsonTypeInfo.As.PROPERTY;
            }
            builder = builder.inclusion(inclusion);
            builder = builder.typeProperty(jd.property());
            Class defaultImpl = info.defaultImpl();
            if (!defaultImpl.isAnnotation()) {
                builder = builder.defaultImpl(defaultImpl);
            }
            builder = builder.typeIdVisibility(info.visible());
            return builder;
        }
    }
}

