/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.function;

import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Suppliers {
    public static <T> Supplier<T> ofConst(T value) {
        return () -> value;
    }

    public static <T> Supplier<T> lazy(final Supplier<T> supplier) {
        return new Supplier<T>(){
            private T value;
            private volatile boolean isCached;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (this.isCached) {
                    return this.value;
                }
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.isCached) {
                        this.value = supplier.get();
                        if (this.value == null) {
                            throw new NullPointerException(supplier + ".get() returned null");
                        }
                        this.isCached = true;
                    }
                }
                return this.value;
            }
        };
    }

    public static <T> Supplier<T> lazyNullable(final Supplier<T> supplier) {
        return new Supplier<T>(){
            private T value;
            private boolean isCached;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (this.isCached) {
                    return this.value;
                }
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.isCached) {
                        this.value = supplier.get();
                        this.isCached = true;
                    }
                }
                return this.value;
            }
        };
    }

    public static <T> Supplier<T> lazy(final Supplier<T> supplier, final T defaultValue) {
        return new Supplier<T>(){
            private T value;
            private boolean isCached;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (this.isCached) {
                    return this.value;
                }
                3 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.isCached) {
                        this.value = supplier.get();
                        this.isCached = true;
                    }
                }
                return this.value == null ? defaultValue : this.value;
            }
        };
    }

    public static <T> Supplier<T> lazyPredicatable(final Supplier<T> supplier, final Predicate<T> predicate) {
        return new Supplier<T>(){
            private T value;
            private boolean isCached;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                Object v = this.value;
                if (this.isCached && predicate.test(v)) {
                    return v;
                }
                4 var2_2 = this;
                synchronized (var2_2) {
                    if (!this.isCached || !predicate.test(this.value)) {
                        this.value = supplier.get();
                        this.isCached = true;
                    }
                }
                return this.value;
            }
        };
    }
}

