/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.crypto;

import cn.dinodev.spring.commons.crypto.Sm2;
import java.math.BigInteger;
import lombok.Generated;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;

public class Sm2Signature {
    private BigInteger r;
    private BigInteger s;

    public String toString() {
        return this.r.toString(16) + "," + this.s.toString(16);
    }

    public static Sm2Signature fromStandardDSA(byte[] signDSAEncoding) {
        return Sm2Signature.fromStandardDSA((DSAEncoding)StandardDSAEncoding.INSTANCE, signDSAEncoding);
    }

    public static Sm2Signature fromStandardDSA(DSAEncoding dsaEncoding, byte[] signDSAEncoding) {
        BigInteger[] bigIntegers = dsaEncoding.decode(Sm2.SM2_ECC_N, signDSAEncoding);
        BigInteger signR = bigIntegers[0];
        BigInteger signS = bigIntegers[1];
        return new Sm2Signature(signR, signS);
    }

    @Generated
    public BigInteger getR() {
        return this.r;
    }

    @Generated
    public BigInteger getS() {
        return this.s;
    }

    @Generated
    public void setR(BigInteger r) {
        this.r = r;
    }

    @Generated
    public void setS(BigInteger s) {
        this.s = s;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sm2Signature)) {
            return false;
        }
        Sm2Signature other = (Sm2Signature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$r = this.getR();
        BigInteger other$r = other.getR();
        if (this$r == null ? other$r != null : !((Object)this$r).equals(other$r)) {
            return false;
        }
        BigInteger this$s = this.getS();
        BigInteger other$s = other.getS();
        return !(this$s == null ? other$s != null : !((Object)this$s).equals(other$s));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Sm2Signature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $r = this.getR();
        result = result * 59 + ($r == null ? 43 : ((Object)$r).hashCode());
        BigInteger $s = this.getS();
        result = result * 59 + ($s == null ? 43 : ((Object)$s).hashCode());
        return result;
    }

    @Generated
    public Sm2Signature() {
    }

    @Generated
    public Sm2Signature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }
}

