/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.bean;

import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public class BeanSafeCache<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BeanSafeCache.class);
    private final ConcurrentMap<Class<?>, T> strongClassCache = new ConcurrentHashMap(64);
    private final ConcurrentMap<Class<?>, T> softClassCache = new ConcurrentReferenceHashMap(64);
    private final Set<ClassLoader> acceptedClassLoaders = Collections.newSetFromMap(new ConcurrentHashMap(16));

    public void acceptClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader != null) {
            this.acceptedClassLoaders.add(classLoader);
        }
    }

    public void clearClassLoader(@Nullable ClassLoader classLoader) {
        this.acceptedClassLoaders.removeIf(registeredLoader -> this.isUnderneathClassLoader((ClassLoader)registeredLoader, classLoader));
        this.strongClassCache.keySet().removeIf(beanClass -> this.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader));
        this.softClassCache.keySet().removeIf(beanClass -> this.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader));
    }

    public boolean isClassLoaderAccepted(ClassLoader classLoader) {
        for (ClassLoader acceptedLoader : this.acceptedClassLoaders) {
            if (!this.isUnderneathClassLoader(classLoader, acceptedLoader)) continue;
            return true;
        }
        return false;
    }

    public T get(Class<?> beanClass) {
        Object results = this.strongClassCache.get(beanClass);
        if (Objects.nonNull(results)) {
            return (T)results;
        }
        return (T)this.softClassCache.get(beanClass);
    }

    public T getOrElse(Class<?> beanClass, Function<Class<?>, ? extends T> provider) {
        T results = this.get(beanClass);
        if (Objects.nonNull(results)) {
            return results;
        }
        results = provider.apply(beanClass);
        if (Objects.nonNull(results)) {
            this.put(beanClass, results);
        }
        return results;
    }

    public T put(Class<?> beanClass, T info) {
        ConcurrentMap<Class<?>, T> classCacheToUse;
        if (ClassUtils.isCacheSafe(beanClass, (ClassLoader)BeanSafeCache.class.getClassLoader()) || this.isClassLoaderAccepted(beanClass.getClassLoader())) {
            classCacheToUse = this.strongClassCache;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Not strongly caching class [{}] because it is not cache-safe", (Object)beanClass.getName());
            }
            classCacheToUse = this.softClassCache;
        }
        return classCacheToUse.put(beanClass, info);
    }

    public T remove(Class<?> beanClass) {
        Object results = this.strongClassCache.remove(beanClass);
        if (Objects.nonNull(results)) {
            return (T)results;
        }
        return (T)this.softClassCache.remove(beanClass);
    }

    private boolean isUnderneathClassLoader(@Nullable ClassLoader candidate, @Nullable ClassLoader parent) {
        if (candidate == parent) {
            return true;
        }
        if (candidate == null) {
            return false;
        }
        ClassLoader classLoaderToCheck = candidate;
        while (classLoaderToCheck != null) {
            if ((classLoaderToCheck = classLoaderToCheck.getParent()) != parent) continue;
            return true;
        }
        return false;
    }
}

