/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.bean;

import cn.dinodev.spring.commons.bean.BeanMeta;
import cn.dinodev.spring.commons.bean.Property;
import cn.dinodev.spring.commons.function.Suppliers;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;

public class BeanMetaImpl
implements BeanMeta {
    private Class<?> beanClass;
    private Supplier<Map<String, Property>> propertyDescriptorsSupplier = Suppliers.lazy(() -> {
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(this.beanClass);
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>(pds.length);
        for (PropertyDescriptor propertyDescriptor : pds) {
            map.put(propertyDescriptor.getName(), new Property(this.beanClass, propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod(), propertyDescriptor.getName()));
        }
        return map;
    });

    public BeanMetaImpl(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Property getProperty(String propertyName) {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return pds.get(propertyName);
    }

    @Override
    public Property[] getProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return pds.values().toArray(new Property[pds.size()]);
    }

    @Override
    public String[] getPropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().map(p -> p.getName()).toArray(String[]::new);
    }

    @Override
    public String[] getReadablePropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().filter(p -> Objects.nonNull(p.getReadMethod())).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getReadableProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (Property[])pds.values().stream().filter(p -> Objects.nonNull(p.getReadMethod())).toArray(Property[]::new);
    }

    @Override
    public String[] getWritablePropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().filter(p -> Objects.nonNull(p.getWriteMethod())).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getWritableProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (Property[])pds.values().stream().filter(p -> Objects.nonNull(p.getWriteMethod())).toArray(Property[]::new);
    }

    @Override
    public String[] getUnreadablePropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().filter(p -> Objects.isNull(p.getReadMethod())).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getUnreadableProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (Property[])pds.values().stream().filter(p -> Objects.isNull(p.getReadMethod())).toArray(Property[]::new);
    }

    @Override
    public String[] getUnwritablePropertyNames() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (String[])pds.values().stream().filter(p -> Objects.isNull(p.getWriteMethod())).map(Property::getName).toArray(String[]::new);
    }

    @Override
    public Property[] getUnwritableProperties() {
        Map<String, Property> pds = this.propertyDescriptorsSupplier.get();
        return (Property[])pds.values().stream().filter(p -> Objects.isNull(p.getWriteMethod())).toArray(Property[]::new);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BeanInfo)) {
            return false;
        }
        return ((BeanMetaImpl)obj).beanClass.equals(this.beanClass);
    }

    public int hashCode() {
        return this.getBeanClass().hashCode();
    }
}

