/*
 * Decompiled with CFR 0.152.
 */
package cn.dhbin.minion.core.common.response;

import cn.dhbin.minion.core.common.response.FailResponse;
import cn.dhbin.minion.core.common.response.IErrorCode;
import cn.dhbin.minion.core.common.response.SuccessResponse;
import java.io.Serializable;
import java.time.LocalDateTime;

public class ApiResponse<T>
implements Serializable {
    private static final long serialVersionUID = 5464910662322777161L;
    private static final int COMMON_SUCCESS = 0;
    private static final int OK = 200;
    private static final int CREATED = 201;
    private static final int NOT_CONTENT = 204;

    public static <T> SuccessResponse<T> success(T object) {
        return ApiResponse.success(object, 0);
    }

    public static <T> SuccessResponse<T> success(T object, int status) {
        return SuccessResponse.builder().status(status).result(object).build();
    }

    public static SuccessResponse<Void> ok() {
        return ApiResponse.ok(null);
    }

    public static <T> SuccessResponse<T> ok(T object) {
        return ApiResponse.success(object, 200);
    }

    public static SuccessResponse<Void> created() {
        return ApiResponse.created(null);
    }

    public static <T> SuccessResponse<T> created(T object) {
        return ApiResponse.success(object, 201);
    }

    public static SuccessResponse<Void> noContent() {
        return ApiResponse.noContent(null);
    }

    public static <T> SuccessResponse<T> noContent(T object) {
        return ApiResponse.success(object, 204);
    }

    public static ApiResponse<?> fail(IErrorCode<?> errorCode) {
        return FailResponse.builder().msg(errorCode.getMsg()).status(errorCode.getStatus()).time(LocalDateTime.now()).build();
    }

    public static ApiResponse<?> fail(IErrorCode<?> errorCode, Exception e) {
        return ApiResponse.fail(errorCode, e, null);
    }

    public static ApiResponse<?> fail(IErrorCode<?> errorCode, Exception e, String msg) {
        return ApiResponse.fail(errorCode, e, msg, false);
    }

    public static ApiResponse<?> fail(IErrorCode<?> errorCode, Exception e, String msg, boolean showErrorMessage) {
        FailResponse.FailResponseBuilder responseBuilder = FailResponse.builder().msg(msg == null ? errorCode.getMsg() : msg).status(errorCode.getStatus()).time(LocalDateTime.now());
        if (e != null && showErrorMessage) {
            responseBuilder.exception(e.getMessage());
        }
        return responseBuilder.build();
    }
}

