package cn.devtech.dmp.musicservices.tidal.utils

import cn.devtech.dmp.musicservices.tidal.data.ResourceType
import cn.devtech.dmp.musicservices.tidal.data.model.AlbumResource
import cn.devtech.dmp.musicservices.tidal.data.model.ArtistResource
import cn.devtech.dmp.musicservices.tidal.data.model.ArtworkResource
import cn.devtech.dmp.musicservices.tidal.data.model.IncludedItem
import cn.devtech.dmp.musicservices.tidal.data.model.PlaylistResource
import cn.devtech.dmp.musicservices.tidal.data.model.TrackResource
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.reflect.TypeToken
import java.lang.reflect.Type


/**
 * 反序列化器 `用于处理TIDAL API返回的included字段中的 polymorphic 类型`
 *
 * @author:袁培根
 * @date:  2025/9/18 9:28
 */
class IncludedItemDeserializer : JsonDeserializer<IncludedItem> {
    override fun deserialize(
        json: JsonElement,
        typeOfT: Type,
        context: JsonDeserializationContext,
    ): IncludedItem {
        val jsonObject = json.asJsonObject
        val type = jsonObject.get("type").asString

        val concreteType: Type = when (type) {
            ResourceType.TRACK.type -> object : TypeToken<TrackResource>() {}.type
            ResourceType.ARTWORK.type -> object : TypeToken<ArtworkResource>() {}.type
            ResourceType.ARTIST.type -> object : TypeToken<ArtistResource>() {}.type
            ResourceType.ALBUM.type -> object : TypeToken<AlbumResource>() {}.type
            ResourceType.PLAYLIST.type -> object : TypeToken<PlaylistResource>() {}.type
            else -> throw IllegalArgumentException("Unknown type: $type")
        }

        return context.deserialize(jsonObject, concreteType)
    }

}