package cn.devtech.dmp.musicservices.tidal.data.model

import cn.devtech.dmp.common.utils.toTimeFormat
import cn.devtech.dmp.musicservices.tidal.data.Track

data class TrackResource(
    val id: String,
    val type: String,
    val attributes: TrackAttributes,
    val relationships: TrackRelationship,
) : IncludedItem

fun TrackResource.toTrack() = Track(
    id = this.id,
    title = this.attributes.title,
    duration = this.attributes.duration.toTimeFormat()
)

fun List<TrackResource>.toTrackList() = this.map { it -> it.toTrack() }