package cn.devtech.dmp.musicservices.tidal.data.model

import cn.devtech.dmp.common.utils.toMinutesAndSecondsFormat
import cn.devtech.dmp.musicservices.tidal.data.Album
import cn.devtech.dmp.musicservices.tidal.data.TrackDetail
import cn.devtech.dmp.musicservices.tidal.data.toCoverArtList

data class TracksResponse(
    val data: List<TrackResource>,
    val included: List<IncludedItem>,
)

fun TracksResponse.toTrackDetailList(): List<TrackDetail> {
    val includedData = this.included
    val artists = includedData.filterIsInstance<ArtistResource>().toArtistList()
    val artworks = includedData.filterIsInstance<ArtworkResource>()
    val albums = includedData.filterIsInstance<AlbumResource>().map { albumResource ->
        Album(
            id = albumResource.id,
            title = albumResource.attributes.title,
            barcodeId = albumResource.attributes.barcodeId,
            numberOfItems = albumResource.attributes.numberOfItems,
            duration = albumResource.attributes.duration.toMinutesAndSecondsFormat(),
            releaseDate = albumResource.attributes.releaseDate,
            coverArts = artworks.filter { it.id == albumResource.relationships.coverArt.data?.firstOrNull()?.id }
                .toCoverArtList(),
            artists = emptyList()
        )
    }
    return this.data.map {
        TrackDetail(
            trackInfo = it.toTrack(),
            artists = artists.filter { artist -> it.relationships.artists.data?.firstOrNull()?.id == artist.id },
            album = albums.first { album -> it.relationships.albums.data?.firstOrNull()?.id == album.id })
    }
}