package cn.devtech.dmp.musicservices.tidal.cache

import cn.devtech.dmp.common.MemoryCache
import cn.devtech.dmp.musicservices.tidal.data.PageArguments
import cn.devtech.dmp.musicservices.tidal.data.Playlist
import cn.devtech.dmp.musicservices.tidal.data.constant.MemoryKey.MEMORY_KEY_ACCESS_TOKEN
import cn.devtech.dmp.musicservices.tidal.data.constant.MemoryKey.MEMORY_KEY_CURRENT_PLAYLIST
import cn.devtech.dmp.musicservices.tidal.data.constant.MemoryKey.MEMORY_KEY_PAGE_ARGUMENTS
import javax.inject.Inject
import javax.inject.Singleton


/**
 * 内存缓存管理器
 *
 * @author:袁培根
 * @date:  2025/9/12 9:28
 */
@Singleton
class MemoryCacheManager @Inject constructor(
    private val memoryCache: MemoryCache<String, Any>,
) {
    fun setPageArguments(pageArguments: PageArguments) {
        memoryCache.put(MEMORY_KEY_PAGE_ARGUMENTS, pageArguments)
    }

    fun getPageArguments(): PageArguments? {
        val value = memoryCache.get(MEMORY_KEY_PAGE_ARGUMENTS) as PageArguments?
        clearPageArguments()
        return value
    }

    fun setCurrentPlaylist(playlist: Playlist) {
        memoryCache.put(MEMORY_KEY_CURRENT_PLAYLIST, playlist)
    }

    fun getCurrentPlaylist(): Playlist? {
        val value = memoryCache.get(MEMORY_KEY_CURRENT_PLAYLIST) as Playlist?
        clearCurrentPlaylist()
        return value
    }

    private fun clearCurrentPlaylist() {
        memoryCache.remove(MEMORY_KEY_CURRENT_PLAYLIST)
    }

    private fun clearPageArguments() {
        memoryCache.remove(MEMORY_KEY_PAGE_ARGUMENTS)
    }

    fun setAccessToken(accessToken: String) {
        memoryCache.put(MEMORY_KEY_ACCESS_TOKEN, accessToken)
    }

    fun getAccessToken(): String? {
        return memoryCache.get(MEMORY_KEY_ACCESS_TOKEN) as String?
    }

    fun clearAccessToken() {
        memoryCache.remove(MEMORY_KEY_ACCESS_TOKEN)
    }
}