package cn.devtech.dmp.musicservices.tidal

import android.content.Context
import cn.devtech.dmp.musicservices.tidal.data.AuthConfig
import com.tidal.sdk.auth.CredentialsProvider
import com.tidal.sdk.auth.TidalAuth
import com.tidal.sdk.auth.network.NetworkLogLevel
import com.tidal.sdk.auth.model.AuthConfig as TidalAuthConfig


/**
 * TIDAL 服务
 *
 * @author:袁培根
 * @date:  2025/9/18 9:18
 */
object TidalService {
    internal var authConfig: AuthConfig? = null

    internal var tidalAuth: TidalAuth? = null
        private set
    internal var credentialsProvider: CredentialsProvider? = null
        private set

    fun initialize(context: Context, config: AuthConfig) {
        authConfig = config
        tidalAuth = initTidalAuth(context)
        credentialsProvider = tidalAuth?.credentialsProvider
    }

    private fun initTidalAuth(context: Context): TidalAuth {
        val tidalAuthConfig = TidalAuthConfig(
            clientId = authConfig?.clientId ?: "",
            clientSecret = authConfig?.clientSecret ?: "",
            scopes = setOf(
                "user.read",
                "collection.read",
                "search.read",
                "playlists.write",
                "collection.write",
                "playlists.read",
                "playback",
                "recommendations.read",
                "entitlements.read",
                "search.write"
            ),
            credentialsKey = "storage",
            enableCertificatePinning = true,
            logLevel = NetworkLogLevel.BODY,
        )
        return TidalAuth.Companion.getInstance(tidalAuthConfig, context)
    }
}