/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.data.model

import com.google.gson.annotations.SerializedName


/**
 * 用户信息
 *
 * @author:袁培根
 * @date:  2025/6/26 15:58
 */
data class UserInfo(
    @SerializedName("user_id") val userId: String,
    @SerializedName("user_name") val userName: String,
    @SerializedName("user_face_s") val userFaceS: String,
    @SerializedName("user_face_m") val userFaceM: String,
    @SerializedName("user_face_l") val userFaceL: String,
    @SerializedName("rt_space_info") val spaceInfo: SpaceInfo,
    @SerializedName("vip_info") val vipInfo: VipInfo,
)

data class SpaceInfo(
    @SerializedName("all_total") val allTotal: Size,
    @SerializedName("all_remain") val allRemain: Size,
    @SerializedName("all_use") val allUse: Size,
)

data class Size(
    @SerializedName("size") val size: Long,
    @SerializedName("size_format") val sizeFormat: String,
)

data class VipInfo(
    @SerializedName("level_name") val levelName: String,
    val expire: Long,
)