/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.data.model

import cn.devtech.dmp.common.utils.isNotNullOrEmptyOrBlank
import com.google.gson.annotations.SerializedName


/**
 * 搜索文件响应体
 *
 * @author:袁培根
 * @date:  2025/7/1 15:58
 */
data class SearchFileResponse(
    val count: Int,
    val data: List<SearchFileInfo>,
    val limit: Int,
    val offset: Int,
    val state: Boolean,
    val message: String,
    val code: Int,
)

data class SearchFileInfo(
    @SerializedName("file_id") val fileId: String,
    @SerializedName("user_id") val userId: String,
    val sha1: String?,
    @SerializedName("file_name") val fileName: String,
    @SerializedName("file_size") val fileSize: String,
    @SerializedName("user_ptime") val userPtime: String,
    @SerializedName("user_utime") val userUtime: String,
    @SerializedName("pick_code") val pickCode: String,
    @SerializedName("parent_id") val parentId: String,
    @SerializedName("area_id") val areaId: String,
    @SerializedName("is_private") val isPrivate: Int,
    @SerializedName("file_category") val fileCategory: String,
    val ico: String?,
)

fun SearchFileInfo.toFileListInfo() = FileListInfo(
    fid = fileId,
    aid = areaId,
    pid = parentId,
    pc = pickCode,
    fn = fileName,
    ism = "0",
    isp = 0,
    upt = if (userPtime.isNotNullOrEmptyOrBlank()) userPtime.toLong() else 0,
    uet = if (userUtime.isNotNullOrEmptyOrBlank()) userUtime.toLong() else 0,
    uppt = if (userPtime.isNotNullOrEmptyOrBlank()) userPtime.toLong() else 0,
    cm = 0,
    sha1 = sha1,
    fdesc = "",
    ispl = 0,
    fs = if (fileSize.isNotNullOrEmptyOrBlank()) fileSize.toLong() else 0,
    fta = "",
    fatr = "",
    isv = 0,
    playLong = 0,
    thumb = "",
    uo = "",
    fc = fileCategory,
    ico = ico
)