/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.data.model

import com.google.gson.annotations.SerializedName


/**
 * 获取在线播放地址响应体
 *
 * @author:袁培根
 * @date:  2025/6/26 15:58
 */
data class PlayUrlResponse(
    val state: Boolean,
    val message: String,
    val code: Int,
    val data: PlayUrlInfo,
)

data class PlayUrlInfo(
    @SerializedName("file_id") val fileId: String,
    @SerializedName("parent_id") val parentId: String,
    @SerializedName("file_name") val fileName: String,
    @SerializedName("file_size") val fileSize: String,
    @SerializedName("file_sha1") val fileSha1: String,
    @SerializedName("file_type") val fileType: String,
    @SerializedName("is_private") val isPrivate: String,
    @SerializedName("play_long") val playLong: String,
    @SerializedName("multitrack_list") val multiTrackList: List<MultiTrack>,
    @SerializedName("video_url") val videoUrl: List<VideoUrlInfo>,
)

data class VideoUrlInfo(
    val url: String,
    val height: Int,
    val width: Int,
    val title: String,
)

data class MultiTrack(
    val title: String,
    @SerializedName("is_selected") val isSelected: String,
)