/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.data.model

import com.google.gson.annotations.SerializedName


/**
 * 获取文件列表响应体
 *
 * @property count 当前目录文件数量
 * @property sysCount 系统文件夹数量
 * @property offset 偏移量
 * @property limit 分页量
 * @property aid 文件的状态，aid 的别名。1 正常，7 删除(回收站)，120 彻底删除
 * @property cid 父目录id
 *
 * @author:袁培根
 * @date:  2025/6/26 15:58
 */
data class FileListResponse(
    val data: List<FileListInfo>,
    val count: Int,
    @SerializedName("sys_count") val sysCount: Int,
    val offset: Int,
    val limit: Int,
    val aid: String,
    val cid: Long,
    val cur: Long,
    val stdir: Long,
    val fields: String,
    val order: String,
    val state: Boolean,
    val code: Int,
    val message: String,
)