/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.data.model

import cn.devtech.dmp.common.utils.isAudioFile
import com.google.gson.annotations.SerializedName


/**
 * 文件列表
 *
 * @property fid 文件ID
 * @property aid 文件的状态，aid 的别名。1 正常，7 删除(回收站)，120 彻底删除
 * @property pid 父目录ID
 * @property fc 文件分类 0 文件夹，1 文件
 * @property fn 文件(夹)名称
 * @property fco 文件夹封面
 * @property ism 是否星标，1：星标
 * @property isp 是否加密；1：加密
 * @property pc 文件提取码
 * @property upt 修改时间
 * @property uet 修改时间
 * @property uppt 上传时间
 * @property fdesc 文件备注
 * @property ispl 是否统计文件夹下视频时长开关
 * @property fs 文件大小
 * @property fta 文件状态 0/2 未上传完成，1 已上传完成
 * @property ico 文件后缀名
 * @property fatr 音频长度
 * @property isv 是否视频
 * @property playLong 音视频时长
 * @property thumb 缩略图
 * @property uo 原图地址
 *
 * @author:袁培根
 * @date:  2025/6/26 15:58
 */
data class FileListInfo(
    val fid: String,
    val aid: String,
    val pid: String,
    val fc: String,
    val fn: String,
    val fco: String? = null,
    val ism: String,
    val isp: Int,
    val pc: String,
    val upt: Long,
    val uet: Long,
    val uppt: Long,
    val cm: Int,
    val fdesc: String,
    val ispl: Int,
    val sha1: String?,
    val fs: Long,
    val fta: String,
    val ico: String?,
    val fatr: String?,
    val isv: Int,
    @SerializedName("play_long") val playLong: Long,
    val thumb: String? = null,
    val uo: String? = null,
    val playUrl: String? = null,
)

fun FileListInfo.isAudioFile() = ico?.isAudioFile() == true

fun FileListInfo.isFolder() = fc == "0"