/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.data.constant


/**
 * 115网盘 API接口地址
 *
 * @author:袁培根
 * @date:  2025/6/26 10:58
 */
object ApiUri {
    const val BASE_URL = "https://proapi.115.com/"
    const val AUTH_URL = "https://passportapi.115.com/"
    const val QRCODE_URL = "https://qrcodeapi.115.com/"

    // 获取设备码
    const val DEVICE_CODE = "open/authDeviceCode"

    // 二维码状态
    const val QRCODE_STATUS = "get/status/"

    // 获取 Token
    const val ACCESS_TOKEN = "open/deviceCodeToToken"

    // 刷新 Token
    const val REFRESH_TOKEN = "open/refreshToken"

    // 获取用户信息
    const val USER_INFO = "open/user/info"

    // 获取文件列表
    const val FILE_LIST = "open/ufile/files"

    // 获取文件信息
    const val FILE_INFO = "open/folder/get_info"

    // 更新文件
    const val UPDATE_FILE = "open/ufile/update"

    // 删除文件
    const val DELETE_FILE = "open/ufile/delete"

    // 搜索文件
    const val SEARCH_FILE = "open/ufile/search"

    // 获取在线播放地址
    const val PLAY_URL = "open/video/play"

    // 获取文件下载地址
    const val DOWNLOAD_URL = "open/ufile/downurl"
}