/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.api.service

import cn.devtech.dmp.musicservices.netdisk115.data.constant.ApiUri
import cn.devtech.dmp.musicservices.netdisk115.data.model.BaseResponse
import cn.devtech.dmp.musicservices.netdisk115.data.model.QrcodeStatus
import retrofit2.http.GET
import retrofit2.http.Query


/**
 * 115网盘 二维码接口定义
 *
 * @author:袁培根
 * @date:  2025/6/26 10:28
 */
interface QrCodeApi {

    /**
     * 获取二维码状态
     */
    @GET(ApiUri.QRCODE_STATUS)
    suspend fun getQrcodeStatus(
        @Query("uid") uid: String,
        @Query("time") time: Long,
        @Query("sign") sign: String,
    ): BaseResponse<QrcodeStatus>
}