/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.api.service

import cn.devtech.dmp.musicservices.netdisk115.data.constant.ApiUri
import cn.devtech.dmp.musicservices.netdisk115.data.model.BaseResponse
import cn.devtech.dmp.musicservices.netdisk115.data.model.FileInfoResponse
import cn.devtech.dmp.musicservices.netdisk115.data.model.FileListResponse
import cn.devtech.dmp.musicservices.netdisk115.data.model.OperationResponse
import cn.devtech.dmp.musicservices.netdisk115.data.model.PlayUrlResponse
import cn.devtech.dmp.musicservices.netdisk115.data.model.SearchFileResponse
import cn.devtech.dmp.musicservices.netdisk115.data.model.UpdateFileResult
import cn.devtech.dmp.musicservices.netdisk115.data.model.UserInfo
import com.google.gson.JsonObject
import retrofit2.http.Field
import retrofit2.http.FormUrlEncoded
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.POST
import retrofit2.http.Query


/**
 * 115网盘 API接口定义
 *
 * @author:袁培根
 * @date:  2025/6/26 10:28
 */
interface NetdiskApi {

    /**
     * 获取用户信息
     */
    @GET(ApiUri.USER_INFO)
    suspend fun getUserInfo(): BaseResponse<UserInfo>

    /**
     * 获取文件列表
     */
    @GET(ApiUri.FILE_LIST)
    suspend fun getFileList(
        @Query("cid") cid: String? = null,
        @Query("type") type: String? = null,
        @Query("limit") limit: Int,
        @Query("offset") offset: Int,
        @Query("suffix") suffix: String? = null,
        @Query("asc") asc: Int,
        @Query("o") orderBy: String? = null,
        @Query("stdir") dir: Int = 1,
        @Query("star") star: Int = 0,
        @Query("show_dir") showDir: Int = 1,
        @Query("custom_order") customOrder: Int = 1,
    ): FileListResponse

    /**
     * 获取文件信息
     */
    @GET(ApiUri.FILE_INFO)
    suspend fun getFileInfo(
        @Query("file_id") fileId: String,
    ): FileInfoResponse

    /**
     * 更新文件
     */
    @POST(ApiUri.UPDATE_FILE)
    @FormUrlEncoded
    suspend fun updateFile(
        @Field("file_id") fileId: String,
        @Field("file_name") fileName: String,
        @Field("star") star: String,
    ): OperationResponse<UpdateFileResult>

    /**
     * 删除文件
     */
    @POST(ApiUri.DELETE_FILE)
    @FormUrlEncoded
    suspend fun deleteFile(
        @Field("file_ids") fileIds: String,
        @Field("parent_id") parentId: String? = null,
    ): OperationResponse<List<String>>

    /**
     * 搜索文件
     */
    @GET(ApiUri.SEARCH_FILE)
    suspend fun searchFile(
        @Query("search_value") keyword: String,
        @Query("limit") limit: Int,
        @Query("offset") offset: Int,
    ): SearchFileResponse

    /**
     * 获取在线播放地址
     */
    @GET(ApiUri.PLAY_URL)
    suspend fun getPlayUrl(
        @Query("pick_code") pickCode: String,
    ): PlayUrlResponse

    /**
     * 获取文件下载地址
     */
    @POST(ApiUri.DOWNLOAD_URL)
    @FormUrlEncoded
    suspend fun getDownloadUrl(
        @Header("User-Agent") userAgent: String,
        @Field("pick_code") pickCode: String,
    ): OperationResponse<JsonObject>
}