/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.data.model

import com.google.gson.annotations.SerializedName


/**
 * 文件信息响应体
 *
 * @author:袁培根
 * @date:  2025/6/26 18:58
 */
data class FileInfoResponse(
    val state: Boolean,
    val message: String,
    val code: Int,
    val data: FileInfo,
)

/**
 * 文件信息
 *
 * @property count 包含文件总数量
 * @property size 文件(夹)总大小
 * @property sizeByte 文件(夹)总大小(字节单位)
 * @property folderCount 包含文件夹总数量
 * @property playLong 视频时长；-1：正在统计，其他数值为视频时长的数值(单位秒)
 * @property showPlayLong 是否开启展示视频时长
 * @property ptime 上传时间
 * @property utime 修改时间
 * @property fileName 文件名
 * @property pickCode 文件提取码
 * @property fileId 文件(夹)ID
 * @property isMark 是否星标
 * @property openTime 文件(夹)最近打开时间
 * @property fileCategory 文件属性；1；文件；0：文件夹
 *
 */
data class FileInfo(
    val count: String,
    val size: String,
    @SerializedName("size_byte") val sizeByte: Long,
    @SerializedName("folder_count") val folderCount: Int,
    @SerializedName("play_long") val playLong: Int,
    @SerializedName("show_play_long") val showPlayLong: Int,
    val ptime: String,
    val utime: String,
    @SerializedName("file_name") val fileName: String,
    @SerializedName("pick_code") val pickCode: String,
    val sha1: String,
    @SerializedName("file_id") val fileId: String,
    @SerializedName("is_mark") val isMark: String,
    @SerializedName("open_time") val openTime: Long,
    @SerializedName("file_category") val fileCategory: String,
    val paths: List<Path>,
)

/**
 * 文件路径
 *
 * @property fileId 父目录ID
 * @property fileName 父目录名称
 */
data class Path(
    @SerializedName("file_id") val fileId: Long,
    @SerializedName("file_name") val fileName: String,
)