package cn.devtech.dmp.musicservices.netdisk115.cache

import cn.devtech.dmp.common.MemoryCache
import cn.devtech.dmp.musicservices.netdisk115.data.constant.MemoryKey.MEMORY_KEY_ACCESS_TOKEN
import cn.devtech.dmp.musicservices.netdisk115.data.constant.MemoryKey.MEMORY_KEY_CURRENT_FILE_DIRECTORY
import cn.devtech.dmp.musicservices.netdisk115.data.model.FileListInfo
import javax.inject.Inject
import javax.inject.Singleton


/**
 * 内存缓存管理器
 *
 * @author:袁培根
 * @date:  2025/6/27 9:20
 */
@Singleton
class MemoryCacheManager @Inject constructor(
    private val memoryCache: MemoryCache<String, Any>,
) {
    fun setCurrentFileDirectory(fileDirectory: FileListInfo) {
        memoryCache.put(MEMORY_KEY_CURRENT_FILE_DIRECTORY, fileDirectory)
    }

    fun getCurrentFileDirectory(): FileListInfo? {
        return memoryCache.get(MEMORY_KEY_CURRENT_FILE_DIRECTORY) as FileListInfo?
    }

    fun setAccessToken(accessToken: String) {
        memoryCache.put(MEMORY_KEY_ACCESS_TOKEN, accessToken)
    }

    fun getAccessToken(): String? {
        return memoryCache.get(MEMORY_KEY_ACCESS_TOKEN) as String?
    }
}