/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.netdisk115.api.service

import cn.devtech.dmp.musicservices.netdisk115.data.constant.ApiUri
import cn.devtech.dmp.musicservices.netdisk115.data.model.AccessToken
import cn.devtech.dmp.musicservices.netdisk115.data.model.BaseResponse
import cn.devtech.dmp.musicservices.netdisk115.data.model.DeviceCode
import retrofit2.http.Field
import retrofit2.http.FormUrlEncoded
import retrofit2.http.POST


/**
 * 115网盘 授权接口定义
 *
 * @author:袁培根
 * @date:  2025/6/26 10:28
 */
interface AuthApi {

    /**
     * 获取设备码
     */
    @POST(ApiUri.DEVICE_CODE)
    @FormUrlEncoded
    suspend fun getDeviceCode(
        @Field("client_id") clientId: String,
        @Field("code_challenge") codeChallenge: String,
        @Field("code_challenge_method") codeChallengeMethod: String,
    ): BaseResponse<DeviceCode>

    /**
     * 获取Token
     */
    @POST(ApiUri.ACCESS_TOKEN)
    @FormUrlEncoded
    suspend fun getToken(
        @Field("uid") uid: String,
        @Field("code_verifier") codeVerifier: String,
    ): BaseResponse<AccessToken>

    /**
     * 刷新Token
     */
    @POST(ApiUri.REFRESH_TOKEN)
    @FormUrlEncoded
    suspend fun refreshToken(
        @Field("refresh_token") refreshToken: String,
    ): BaseResponse<AccessToken>
}