/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.dropbox.data.model

import cn.devtech.dmp.common.utils.isAudioFileWithName
import cn.devtech.dmp.musicservices.dropbox.data.constant.ApiUri
import com.google.gson.annotations.SerializedName


/**
 * 文件信息
 *
 * @author:袁培根
 * @date:  2025/7/25 15:58
 */
data class FileInfo(
    @SerializedName(".tag") val tag: String,
    @SerializedName("client_modified") val clientModified: String? = null,
    @SerializedName("content_hash") val contentHash: String? = null,
    val id: String,
    val name: String,
    @SerializedName("is_downloadable") val isDownloadable: Boolean? = null,
    @SerializedName("path_display") val pathDisplay: String,
    @SerializedName("path_lower") val pathLower: String,
    val rev: String? = null,
    @SerializedName("server_modified") val serverModified: String? = null,
    @SerializedName("file_owner_team_encrypted_id") val fileOwnerTeamEncryptedId: String? = null,
    val size: Long? = null,
)

fun FileInfo.isFolder() = tag == ApiUri.MIMETYPE_FOLDER

fun FileInfo.isAudioFile() = name.isAudioFileWithName()