/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.dropbox.data.constant


/**
 * Dropbox API接口地址
 *
 * @author:袁培根
 * @date:  2025/7/23 10:58
 */
object ApiUri {
    const val BASE_URL = "https://api.dropboxapi.com/2/"
    const val AUTHORIZATION_URL = "https://www.dropbox.com/oauth2/authorize"
    const val AUTH_URL = "https://api.dropboxapi.com/oauth2/"

    // 访问令牌
    const val TOKEN = "token"

    // 文件管理
    const val FILE = "files"

    const val SCOPE = "files.metadata.read" +
            " files.content.write" +
            " files.content.read"

    const val MIMETYPE_FOLDER = "folder"
}