package cn.devtech.dmp.musicservices.dropbox.cache

import cn.devtech.dmp.common.MemoryCache
import cn.devtech.dmp.musicservices.dropbox.data.constant.MemoryKey.MEMORY_KEY_ACCESS_TOKEN
import cn.devtech.dmp.musicservices.dropbox.data.constant.MemoryKey.MEMORY_KEY_CURRENT_FILE_DIRECTORY
import cn.devtech.dmp.musicservices.dropbox.data.model.FileInfo
import javax.inject.Inject
import javax.inject.Singleton


/**
 * 内存缓存管理器
 *
 * @author:袁培根
 * @date:  2025/7/23 9:20
 */
@Singleton
class MemoryCacheManager @Inject constructor(
    private val memoryCache: MemoryCache<String, Any>,
) {
    fun setCurrentFileDirectory(fileDirectory: FileInfo) {
        memoryCache.put(MEMORY_KEY_CURRENT_FILE_DIRECTORY, fileDirectory)
    }

    fun getCurrentFileDirectory(): FileInfo? {
        return memoryCache.get(MEMORY_KEY_CURRENT_FILE_DIRECTORY) as FileInfo?
    }

    fun setAccessToken(accessToken: String) {
        memoryCache.put(MEMORY_KEY_ACCESS_TOKEN, accessToken)
    }

    fun getAccessToken(): String? {
        return memoryCache.get(MEMORY_KEY_ACCESS_TOKEN) as String?
    }
}