/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.dropbox.api.service

import cn.devtech.dmp.musicservices.dropbox.data.constant.ApiUri
import cn.devtech.dmp.musicservices.dropbox.data.model.FileListResponse
import cn.devtech.dmp.musicservices.dropbox.data.model.OperationResponse
import cn.devtech.dmp.musicservices.dropbox.data.model.SearchResultResponse
import cn.devtech.dmp.musicservices.dropbox.data.model.TemporaryLinkResponse
import com.google.gson.JsonObject
import retrofit2.http.Body
import retrofit2.http.POST


/**
 * Dropbox API接口定义
 *
 * @author:袁培根
 * @date:  2025/7/25 10:28
 */
interface DropboxApi {

    /**
     * 获取文件列表
     */
    @POST("${ApiUri.FILE}/list_folder")
    suspend fun getFileList(
        @Body request: JsonObject,
    ): FileListResponse

    /**
     * 获取下一页文件列表
     */
    @POST("${ApiUri.FILE}/list_folder/continue")
    suspend fun getFileListContinue(
        @Body request: JsonObject,
    ): FileListResponse

    /**
     * 搜索文件
     */
    @POST("${ApiUri.FILE}/search_v2")
    suspend fun searchFile(
        @Body request: JsonObject,
    ): SearchResultResponse

    /**
     * 搜索文件下一页
     */
    @POST("${ApiUri.FILE}/search/continue_v2")
    suspend fun searchFileContinue(
        @Body request: JsonObject,
    ): SearchResultResponse

    /**
     * 删除文件
     */
    @POST("${ApiUri.FILE}/delete_v2")
    suspend fun deleteFile(
        @Body request: JsonObject,
    ): OperationResponse

    /**
     * 移动文件
     */
    @POST("${ApiUri.FILE}/move_v2")
    suspend fun moveFile(
        @Body fileInfo: JsonObject,
    ): OperationResponse

    /**
     * 获取文件的临时链接
     */
    @POST("${ApiUri.FILE}/get_temporary_link")
    suspend fun getTemporaryLink(
        @Body request: JsonObject,
    ): TemporaryLinkResponse
}