/*
 * Copyright (c) 2025. 深圳市德为信息技术有限公司, 深圳市诠云科技有限公司 保留所有权利。
 *
 * 根据《中华人民共和国著作权法》、《计算机软件保护条例》及相关法律法规，
 * 本软件著作权归属于深圳市德为信息技术有限公司与深圳市诠云科技有限公司共同所有，
 * 任何单位或个人未经书面授权不得复制、修改、分发或用于商业用途。
 * （本声明适用于本项目所有源代码、资源配置文件及文档资料）
 */

package cn.devtech.dmp.musicservices.dropbox.api

import cn.devtech.dmp.musicservices.dropbox.cache.MemoryCacheManager
import okhttp3.Interceptor
import okhttp3.Response
import javax.inject.Inject
import javax.inject.Singleton


/**
 * Dropbox API 身份认证拦截器
 * `负责为每个请求添加必要的认证头部`
 *
 * @author:袁培根
 * @date:  2025/7/25 17:58
 */
@Singleton
class AuthInterceptor @Inject constructor(
    private val memoryCacheManager: MemoryCacheManager,
) : Interceptor {

    override fun intercept(chain: Interceptor.Chain): Response {

        val originalRequest = chain.request()

        val token = memoryCacheManager.getAccessToken() ?: ""

        // 创建新的请求，添加所有必要的头部
        val newRequest = originalRequest.newBuilder()
            .header("Charset", "UTF-8")
            .header("Authorization", "Bearer $token")
            .build()

        // 执行请求
        val response = chain.proceed(newRequest)

        return response
    }

}