/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.temp.jwt;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.temp.SaTempInterface;
import cn.dev33.satoken.temp.jwt.SaJwtUtil;
import cn.dev33.satoken.util.SaFoxUtil;

public class SaTempForJwt
implements SaTempInterface {
    public String createToken(String service, Object value, long timeout) {
        String token = SaJwtUtil.createToken(service, value, timeout, this.getJwtSecretKey());
        return token;
    }

    public Object parseToken(String service, String token) {
        Object value = SaJwtUtil.getValue(service, token, this.getJwtSecretKey());
        return value;
    }

    public long getTimeout(String service, String token) {
        long timeout = SaJwtUtil.getTimeout(service, token, this.getJwtSecretKey());
        return timeout;
    }

    public void deleteToken(String service, String token) {
        throw new ApiDisabledException("jwt cannot delete token").setCode(30302);
    }

    public String getJwtSecretKey() {
        String jwtSecretKey = SaManager.getConfig().getJwtSecretKey();
        if (SaFoxUtil.isEmpty((Object)jwtSecretKey)) {
            throw new SaTokenException("\u8bf7\u914d\u7f6e\uff1ajwtSecretKey").setCode(30301);
        }
        return jwtSecretKey;
    }
}

