/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaSsoConfig;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.sign.SaSignTemplate;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.name.ApiName;
import cn.dev33.satoken.sso.name.ParamName;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SaSsoTemplate {
    public ApiName apiName = new ApiName();
    public ParamName paramName = new ParamName();

    public SaSsoTemplate setParamName(ParamName paramName) {
        this.paramName = paramName;
        return this;
    }

    public SaSsoTemplate setApiName(ApiName apiName) {
        this.apiName = apiName;
        return this;
    }

    public StpLogic getStpLogic() {
        return StpUtil.stpLogic;
    }

    public SaSsoConfig getSsoConfig() {
        return SaSsoManager.getConfig();
    }

    public SaSignTemplate getSignTemplate() {
        return SaManager.getSaSignTemplate();
    }

    public void saveTicket(String ticket, Object loginId) {
        long ticketTimeout = SaSsoManager.getConfig().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketSaveKey(ticket), String.valueOf(loginId), ticketTimeout);
    }

    public void saveTicketIndex(String ticket, Object loginId) {
        long ticketTimeout = SaSsoManager.getConfig().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketIndexKey(loginId), String.valueOf(ticket), ticketTimeout);
    }

    public void saveTicketToClient(String ticket, String client) {
        if (SaFoxUtil.isEmpty((Object)client)) {
            return;
        }
        long ticketTimeout = SaSsoManager.getConfig().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketToClientSaveKey(ticket), client, ticketTimeout);
    }

    public void deleteTicket(String ticket) {
        if (ticket == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketSaveKey(ticket));
    }

    public void deleteTicketIndex(Object loginId) {
        if (loginId == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketIndexKey(loginId));
    }

    public void deleteTicketToClient(String ticket) {
        if (ticket == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketToClientSaveKey(ticket));
    }

    public Object getLoginId(String ticket) {
        if (SaFoxUtil.isEmpty((Object)ticket)) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketSaveKey(ticket));
    }

    public <T> T getLoginId(String ticket, Class<T> cs) {
        return (T)SaFoxUtil.getValueByType((Object)this.getLoginId(ticket), cs);
    }

    public String getTicketValue(Object loginId) {
        if (loginId == null) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketIndexKey(loginId));
    }

    public String getTicketToClient(String ticket) {
        if (SaFoxUtil.isEmpty((Object)ticket)) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketToClientSaveKey(ticket));
    }

    public String createTicket(Object loginId, String client) {
        String ticket = this.randomTicket(loginId);
        this.saveTicket(ticket, loginId);
        this.saveTicketIndex(ticket, loginId);
        this.saveTicketToClient(ticket, client);
        return ticket;
    }

    public Object checkTicket(String ticket) {
        return this.checkTicket(ticket, this.getSsoConfig().getClient());
    }

    public Object checkTicket(String ticket, String client) {
        String loginId = SaManager.getSaTokenDao().get(this.splicingTicketSaveKey(ticket));
        if (loginId != null) {
            String ticketClient = this.getTicketToClient(ticket);
            if (SaFoxUtil.isNotEmpty((Object)client) && SaFoxUtil.notEquals((Object)client, (Object)ticketClient)) {
                throw new SaSsoException("\u8be5 ticket \u4e0d\u5c5e\u4e8e client=" + client + ", ticket \u503c: " + ticket).setCode(30011);
            }
            this.deleteTicket(ticket);
            this.deleteTicketIndex(loginId);
            this.deleteTicketToClient(ticket);
        }
        return loginId;
    }

    public String randomTicket(Object loginId) {
        return SaFoxUtil.getRandomString((int)64);
    }

    public String getAllowUrl() {
        return SaSsoManager.getConfig().getAllowUrl();
    }

    public void checkRedirectUrl(String url) {
        List<String> authUrlList;
        if (!SaFoxUtil.isUrl((String)url)) {
            throw new SaSsoException("\u65e0\u6548redirect\uff1a" + url).setCode(30001);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        if (!((Boolean)SaStrategy.instance.hasElement.apply(authUrlList = Arrays.asList(this.getAllowUrl().replaceAll(" ", "").split(",")), (Object)url)).booleanValue()) {
            throw new SaSsoException("\u975e\u6cd5redirect\uff1a" + url).setCode(30002);
        }
    }

    public void registerSloCallbackUrl(Object loginId, String sloCallbackUrl) {
        if (SaFoxUtil.isEmpty((Object)loginId) || SaFoxUtil.isEmpty((Object)sloCallbackUrl)) {
            return;
        }
        SaSession session = this.getStpLogic().getSessionByLoginId(loginId);
        Set urlSet = (Set)session.get("SLO_CALLBACK_SET_KEY_", HashSet::new);
        urlSet.add(sloCallbackUrl);
        session.set("SLO_CALLBACK_SET_KEY_", (Object)urlSet);
    }

    public void ssoLogout(Object loginId) {
        SaSession session = this.getStpLogic().getSessionByLoginId(loginId, false);
        if (session == null) {
            return;
        }
        SaSsoConfig cfg = SaSsoManager.getConfig();
        Set urlSet = (Set)session.get("SLO_CALLBACK_SET_KEY_", HashSet::new);
        for (String url : urlSet) {
            url = this.joinLoginIdAndSign(url, loginId);
            cfg.getSendHttp().apply(url);
        }
        this.getStpLogic().logout(loginId);
    }

    public Object getData(Map<String, Object> paramMap) {
        String getDataUrl = SaSsoManager.getConfig().splicingGetDataUrl();
        return this.getData(getDataUrl, paramMap);
    }

    public Object getData(String path, Map<String, Object> paramMap) {
        String url = this.buildCustomPathUrl(path, paramMap);
        return SaSsoManager.getConfig().getSendHttp().apply(url);
    }

    public String buildServerAuthUrl(String clientLoginUrl, String back) {
        String serverUrl = SaSsoManager.getConfig().splicingAuthUrl();
        String client = SaSsoManager.getConfig().getClient();
        if (SaFoxUtil.isNotEmpty((Object)client)) {
            serverUrl = SaFoxUtil.joinParam((String)serverUrl, (String)this.paramName.client, (Object)client);
        }
        back = back == null ? "" : back;
        back = SaFoxUtil.encodeUrl((String)back);
        if (!clientLoginUrl.contains(this.paramName.back + "=" + back)) {
            clientLoginUrl = SaFoxUtil.joinParam((String)clientLoginUrl, (String)this.paramName.back, (Object)back);
        }
        return SaFoxUtil.joinParam((String)serverUrl, (String)this.paramName.redirect, (Object)clientLoginUrl);
    }

    public String buildRedirectUrl(Object loginId, String client, String redirect) {
        this.checkRedirectUrl(redirect);
        this.deleteTicket(this.getTicketValue(loginId));
        String ticket = this.createTicket(loginId, client);
        return SaFoxUtil.joinParam((String)this.encodeBackParam(redirect), (String)this.paramName.ticket, (Object)ticket);
    }

    public String encodeBackParam(String url) {
        int index = url.indexOf("?" + this.paramName.back + "=");
        if (index == -1 && (index = url.indexOf("&" + this.paramName.back + "=")) == -1) {
            return url;
        }
        int length = this.paramName.back.length() + 2;
        String back = url.substring(index + length);
        back = SaFoxUtil.encodeUrl((String)back);
        url = url.substring(0, index + length) + back;
        return url;
    }

    public String buildCheckTicketUrl(String ticket, String ssoLogoutCallUrl) {
        String url = SaSsoManager.getConfig().splicingCheckTicketUrl();
        String client = this.getSsoConfig().getClient();
        if (SaFoxUtil.isNotEmpty((Object)client)) {
            url = SaFoxUtil.joinParam((String)url, (String)this.paramName.client, (Object)client);
        }
        url = SaFoxUtil.joinParam((String)url, (String)this.paramName.ticket, (Object)ticket);
        if (ssoLogoutCallUrl != null) {
            url = SaFoxUtil.joinParam((String)url, (String)this.paramName.ssoLogoutCall, (Object)ssoLogoutCallUrl);
        }
        return url;
    }

    public String buildSloUrl(Object loginId) {
        String url = SaSsoManager.getConfig().splicingSloUrl();
        return this.joinLoginIdAndSign(url, loginId);
    }

    public String buildGetDataUrl(Map<String, Object> paramMap) {
        String getDataUrl = SaSsoManager.getConfig().getGetDataUrl();
        return this.buildCustomPathUrl(getDataUrl, paramMap);
    }

    public String buildCustomPathUrl(String path, Map<String, Object> paramMap) {
        String url = path;
        if (!url.startsWith("http")) {
            String serverUrl = SaSsoManager.getConfig().getServerUrl();
            SaSsoException.throwByNull((Object)serverUrl, (String)"\u8bf7\u5148\u914d\u7f6e sa-token.sso.server-url \u5730\u5740", (int)30012);
            url = SaFoxUtil.spliceTwoUrl((String)serverUrl, (String)path);
        }
        return this.joinParamMapAndSign(url, paramMap);
    }

    public SaResult request(String url) {
        String body = SaSsoManager.getConfig().getSendHttp().apply(url);
        Map map = SaManager.getSaJsonTemplate().parseJsonToMap(body);
        return new SaResult(map);
    }

    public String joinParamMapAndSign(String url, Map<String, Object> paramMap) {
        SaManager.getSaSignTemplate().addSignParams(paramMap);
        String signParams = SaManager.getSaSignTemplate().joinParams(paramMap);
        return SaFoxUtil.joinParam((String)url, (String)signParams);
    }

    public String joinLoginIdAndSign(String url, Object loginId) {
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        paramMap.put(this.paramName.loginId, loginId);
        return this.joinParamMapAndSign(url, paramMap);
    }

    public String splicingTicketSaveKey(String ticket) {
        return this.getStpLogic().getConfigOrGlobal().getTokenName() + ":ticket:" + ticket;
    }

    public String splicingTicketToClientSaveKey(String ticket) {
        return this.getStpLogic().getConfigOrGlobal().getTokenName() + ":ticket-client:" + ticket;
    }

    public String splicingTicketIndexKey(Object id) {
        return this.getStpLogic().getConfigOrGlobal().getTokenName() + ":id-ticket:" + id;
    }

    @Deprecated
    public String buildUserinfoUrl(Object loginId) {
        String userinfoUrl = SaSsoManager.getConfig().splicingUserinfoUrl();
        return this.joinLoginIdAndSign(userinfoUrl, loginId);
    }

    @Deprecated
    public Object getUserinfo(Object loginId) {
        String url = this.buildUserinfoUrl(loginId);
        return this.request(url);
    }
}

