/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.noear.redisx.RedisClient;
import org.noear.redisx.plus.RedisBucket;

public class SaTokenDaoOfRedisBase64
implements SaTokenDao {
    private final RedisBucket redisBucket;

    public SaTokenDaoOfRedisBase64(Properties props) {
        this(new RedisClient(props));
    }

    public SaTokenDaoOfRedisBase64(RedisClient redisClient) {
        this.redisBucket = redisClient.getBucket();
    }

    public String get(String key) {
        return this.redisBucket.get(key);
    }

    public void set(String key, String value, long timeout) {
        if (timeout > 0L || timeout == -1L) {
            this.redisBucket.store(key, value, (int)timeout);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.redisBucket.remove(key);
    }

    public long getTimeout(String key) {
        return this.redisBucket.ttl(key);
    }

    public void updateTimeout(String key, long timeout) {
        if (this.redisBucket.exists(key).booleanValue()) {
            this.redisBucket.delay(key, (int)timeout);
        }
    }

    public Object getObject(String key) {
        return this.redisBucket.getAndDeserialize(key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout > 0L || timeout == -1L) {
            this.redisBucket.storeAndSerialize(key, object, (int)timeout);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        this.redisBucket.remove(key);
    }

    public long getObjectTimeout(String key) {
        return this.redisBucket.ttl(key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (this.redisBucket.exists(key).booleanValue()) {
            this.redisBucket.delay(key, (int)timeout);
        }
    }

    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        Set keys = this.redisBucket.keys(prefix + "*" + keyword + "*");
        ArrayList list = new ArrayList(keys);
        return SaFoxUtil.searchList(list, (int)start, (int)size, (boolean)sortType);
    }
}

