/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.dao.SaSessionForJacksonCustomized;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RBucketAsync;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class SaTokenDaoRedissonJackson
implements SaTokenDao {
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    public ObjectMapper objectMapper;
    public Codec codec;
    public RedissonClient redissonClient;
    public boolean isInit;

    @Autowired
    public void init(RedissonClient redissonClient) {
        if (this.isInit) {
            return;
        }
        GenericJackson2JsonRedisSerializer valueSerializer = new GenericJackson2JsonRedisSerializer();
        try {
            Field field = GenericJackson2JsonRedisSerializer.class.getDeclaredField("mapper");
            field.setAccessible(true);
            this.objectMapper = (ObjectMapper)field.get(valueSerializer);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            JavaTimeModule timeModule = new JavaTimeModule();
            timeModule.addSerializer((JsonSerializer)new LocalDateTimeSerializer(DATE_TIME_FORMATTER));
            timeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DATE_TIME_FORMATTER));
            timeModule.addSerializer((JsonSerializer)new LocalDateSerializer(DATE_FORMATTER));
            timeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DATE_FORMATTER));
            timeModule.addSerializer((JsonSerializer)new LocalTimeSerializer(TIME_FORMATTER));
            timeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(TIME_FORMATTER));
            this.objectMapper.registerModule((Module)timeModule);
            SaStrategy.instance.createSession = sessionId -> new SaSessionForJacksonCustomized((String)sessionId);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        this.codec = new JsonJacksonCodec(this.objectMapper);
        this.redissonClient = redissonClient;
        this.isInit = true;
    }

    public String get(String key) {
        RBucket rBucket = this.redissonClient.getBucket(key, this.codec);
        return (String)rBucket.get();
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            RBucket bucket = this.redissonClient.getBucket(key, this.codec);
            bucket.set((Object)value);
        } else {
            RBatch batch = this.redissonClient.createBatch();
            RBucketAsync bucket = batch.getBucket(key, this.codec);
            bucket.setAsync((Object)value);
            bucket.expireAsync(Duration.ofSeconds(timeout));
            batch.execute();
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.redissonClient.getBucket(key, this.codec).delete();
    }

    public long getTimeout(String key) {
        RBucket rBucket = this.redissonClient.getBucket(key, this.codec);
        long timeout = rBucket.remainTimeToLive();
        return timeout < 0L ? timeout : timeout / 1000L;
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        RBucket rBucket = this.redissonClient.getBucket(key, this.codec);
        rBucket.expire(Duration.ofSeconds(timeout));
    }

    public Object getObject(String key) {
        RBucket rBucket = this.redissonClient.getBucket(key, this.codec);
        return rBucket.get();
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            RBucket bucket = this.redissonClient.getBucket(key, this.codec);
            bucket.set(object);
        } else {
            RBatch batch = this.redissonClient.createBatch();
            RBucketAsync bucket = batch.getBucket(key, this.codec);
            bucket.setAsync(object);
            bucket.expireAsync(Duration.ofSeconds(timeout));
            batch.execute();
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        this.redissonClient.getBucket(key, this.codec).delete();
    }

    public long getObjectTimeout(String key) {
        RBucket rBucket = this.redissonClient.getBucket(key, this.codec);
        long timeout = rBucket.remainTimeToLive();
        return timeout < 0L ? timeout : timeout / 1000L;
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        RBucket rBucket = this.redissonClient.getBucket(key, this.codec);
        rBucket.expire(Duration.ofSeconds(timeout));
    }

    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        Stream stream = this.redissonClient.getKeys().getKeysStreamByPattern(prefix + "*" + keyword + "*");
        List list = stream.collect(Collectors.toList());
        return SaFoxUtil.searchList(list, (int)start, (int)size, (boolean)sortType);
    }
}

