/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.dao.SaTokenDaoForRedisTemplate;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class SaTokenDaoForRedisTemplateUseJdkSerializer
extends SaTokenDaoForRedisTemplate
implements SaTokenDao {
    public RedisTemplate<String, Object> objectRedisTemplate;

    @Override
    protected void initMore(RedisConnectionFactory connectionFactory) {
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer valueSerializer = new JdkSerializationRedisSerializer();
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        template.setKeySerializer((RedisSerializer)keySerializer);
        template.setHashKeySerializer((RedisSerializer)keySerializer);
        template.setValueSerializer((RedisSerializer)valueSerializer);
        template.setHashValueSerializer((RedisSerializer)valueSerializer);
        template.afterPropertiesSet();
        this.objectRedisTemplate = template;
    }

    public Object getObject(String key) {
        return this.objectRedisTemplate.opsForValue().get((Object)key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.objectRedisTemplate.opsForValue().set((Object)key, object);
        } else {
            this.objectRedisTemplate.opsForValue().set((Object)key, object, timeout, TimeUnit.SECONDS);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        this.objectRedisTemplate.delete((Object)key);
    }

    public long getObjectTimeout(String key) {
        return this.objectRedisTemplate.getExpire((Object)key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        this.objectRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }
}

