/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.data.generate;

import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.consts.GrantType;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.dao.SaOAuth2Dao;
import cn.dev33.satoken.oauth2.data.convert.SaOAuth2DataConverter;
import cn.dev33.satoken.oauth2.data.generate.SaOAuth2DataGenerate;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.CodeModel;
import cn.dev33.satoken.oauth2.data.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import cn.dev33.satoken.oauth2.data.model.request.RequestAuthModel;
import cn.dev33.satoken.oauth2.exception.SaOAuth2AuthorizationCodeException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.oauth2.exception.SaOAuth2RefreshTokenException;
import cn.dev33.satoken.oauth2.strategy.SaOAuth2Strategy;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;

public class SaOAuth2DataGenerateDefaultImpl
implements SaOAuth2DataGenerate {
    @Override
    public CodeModel generateCode(RequestAuthModel ra) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        dao.deleteCode(dao.getCodeValue(ra.clientId, ra.loginId));
        String codeValue = SaOAuth2Strategy.instance.createCodeValue.execute(ra.clientId, ra.loginId, ra.scopes);
        CodeModel cm = new CodeModel(codeValue, ra.clientId, ra.scopes, ra.loginId, ra.redirectUri, ra.getNonce());
        dao.saveCode(cm);
        dao.saveCodeIndex(cm);
        dao.saveCodeNonceIndex(cm);
        return cm;
    }

    @Override
    public AccessTokenModel generateAccessToken(String code) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        SaOAuth2DataConverter dataConverter = SaOAuth2Manager.getDataConverter();
        CodeModel cm = dao.getCode(code);
        SaOAuth2AuthorizationCodeException.throwBy(cm == null, "\u65e0\u6548 code: " + code, code, 30110);
        dao.deleteAccessToken(dao.getAccessTokenValue(cm.clientId, cm.loginId));
        dao.deleteRefreshToken(dao.getRefreshTokenValue(cm.clientId, cm.loginId));
        AccessTokenModel at = dataConverter.convertCodeToAccessToken(cm);
        SaOAuth2Strategy.instance.workAccessTokenByScope.accept(at);
        RefreshTokenModel rt = dataConverter.convertAccessTokenToRefreshToken(at);
        at.refreshToken = rt.refreshToken;
        at.refreshExpiresTime = rt.expiresTime;
        dao.saveAccessToken(at);
        dao.saveAccessTokenIndex(at);
        dao.saveRefreshToken(rt);
        dao.saveRefreshTokenIndex(rt);
        dao.deleteCode(code);
        dao.deleteCodeIndex(cm.clientId, cm.loginId);
        return at;
    }

    @Override
    public AccessTokenModel refreshAccessToken(String refreshToken) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        RefreshTokenModel rt = dao.getRefreshToken(refreshToken);
        SaOAuth2RefreshTokenException.throwBy(rt == null, "\u65e0\u6548 refresh_token: " + refreshToken, refreshToken, 30111);
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(rt.clientId);
        if (clientModel.getIsNewRefresh().booleanValue()) {
            dao.deleteRefreshToken(rt.refreshToken);
            rt = SaOAuth2Manager.getDataConverter().convertRefreshTokenToRefreshToken(rt);
            dao.saveRefreshToken(rt);
            dao.saveRefreshTokenIndex(rt);
        }
        dao.deleteAccessToken(dao.getAccessTokenValue(rt.clientId, rt.loginId));
        AccessTokenModel at = SaOAuth2Manager.getDataConverter().convertRefreshTokenToAccessToken(rt);
        dao.saveAccessToken(at);
        dao.saveAccessTokenIndex(at);
        return at;
    }

    @Override
    public AccessTokenModel generateAccessToken(RequestAuthModel ra, boolean isCreateRt, Consumer<AccessTokenModel> appendWork) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        dao.deleteAccessToken(dao.getAccessTokenValue(ra.clientId, ra.loginId));
        if (isCreateRt) {
            dao.deleteRefreshToken(dao.getRefreshTokenValue(ra.clientId, ra.loginId));
        }
        String newAtValue = SaOAuth2Strategy.instance.createAccessToken.execute(ra.clientId, ra.loginId, ra.scopes);
        AccessTokenModel at = new AccessTokenModel(newAtValue, ra.clientId, ra.loginId, ra.scopes);
        at.tokenType = SaOAuth2Consts.TokenType.bearer;
        if (appendWork != null) {
            appendWork.accept(at);
        }
        at.extraData = new LinkedHashMap<String, Object>();
        SaOAuth2Strategy.instance.workAccessTokenByScope.accept(at);
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(ra.clientId);
        at.expiresTime = System.currentTimeMillis() + clientModel.getAccessTokenTimeout() * 1000L;
        if (isCreateRt) {
            RefreshTokenModel rt = SaOAuth2Manager.getDataConverter().convertAccessTokenToRefreshToken(at);
            at.refreshToken = rt.refreshToken;
            at.refreshExpiresTime = rt.expiresTime;
            dao.saveRefreshToken(rt);
            dao.saveRefreshTokenIndex(rt);
        }
        dao.saveAccessToken(at);
        dao.saveAccessTokenIndex(at);
        return at;
    }

    @Override
    public ClientTokenModel generateClientToken(String clientId, List<String> scopes) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        dao.deleteClientToken(dao.getLowerClientTokenValue(clientId));
        ClientTokenModel oldCt = dao.getClientToken(dao.getClientTokenValue(clientId));
        dao.saveLowerClientTokenIndex(oldCt);
        SaClientModel cm = SaOAuth2Manager.getDataLoader().getClientModelNotNull(clientId);
        if (oldCt != null && cm.getLowerClientTokenTimeout() != -1L) {
            oldCt.expiresTime = System.currentTimeMillis() + cm.getLowerClientTokenTimeout() * 1000L;
            dao.saveClientToken(oldCt);
        }
        String clientTokenValue = SaOAuth2Strategy.instance.createClientToken.execute(clientId, scopes);
        ClientTokenModel ct = new ClientTokenModel(clientTokenValue, clientId, scopes);
        ct.tokenType = SaOAuth2Consts.TokenType.bearer;
        ct.expiresTime = System.currentTimeMillis() + cm.getClientTokenTimeout() * 1000L;
        ct.grantType = GrantType.client_credentials;
        ct.extraData = new LinkedHashMap<String, Object>();
        SaOAuth2Strategy.instance.workClientTokenByScope.accept(ct);
        dao.saveClientToken(ct);
        dao.saveClientTokenIndex(ct);
        return ct;
    }

    @Override
    public String buildRedirectUri(String redirectUri, String code, String state) {
        String url = SaFoxUtil.joinParam((String)redirectUri, (String)SaOAuth2Consts.Param.code, (Object)code);
        if (!SaFoxUtil.isEmpty((Object)state)) {
            this.checkState(state);
            url = SaFoxUtil.joinParam((String)url, (String)SaOAuth2Consts.Param.state, (Object)state);
        }
        return url;
    }

    @Override
    public String buildImplicitRedirectUri(String redirectUri, String token, String state) {
        String url = SaFoxUtil.joinSharpParam((String)redirectUri, (String)SaOAuth2Consts.Param.token, (Object)token);
        if (!SaFoxUtil.isEmpty((Object)state)) {
            this.checkState(state);
            url = SaFoxUtil.joinSharpParam((String)url, (String)SaOAuth2Consts.Param.state, (Object)state);
        }
        return url;
    }

    @Override
    public void checkState(String state) {
        String value = SaOAuth2Manager.getDao().getState(state);
        if (SaFoxUtil.isNotEmpty((Object)value)) {
            throw new SaOAuth2Exception("\u591a\u6b21\u8bf7\u6c42\u7684 state \u4e0d\u53ef\u91cd\u590d: " + state).setCode(30127);
        }
        SaOAuth2Manager.getDao().saveState(state);
    }
}

